@echo off
REM  cls
:MAIN

 rem ---------------------------------------------------------------------------
 rem JobManager V2 Script fuer den DatenExport mit dem PLMJobManager (c) J.Feuerstein
 rem ---------------------------------------------------------------------------
 rem Dokumentation PLMJobManager Scripts/Param anwendbare Parameter:
 rem set=JTExport=true        		= schaltet den Export von JT Files ein
 rem set=ParasolidExport=true 		= schaltet den Parasolid Export ein
 rem set=DXFExport=true       		= schaltet den DXF Export ein
 rem set=DWGExport=true       		= schaltet den DWG Export ein
 rem set=StepExport=true     	 	= schaltet den Step Export ein
 rem set=StepExport=true    	  	= schaltet den Step Export ein
 rem set=JTTCUpdate=true		     	= schaltet JTUpdate ein
 rem set=CheckMate=true         = schaltet CheckMate ein
 rem ---------------------------------------------------------------------------
 rem Aenderungs Info:
 rem                   User   Date/Time (Shift+strg+T)     Infotext:
 set MyApplCurVerInfo=J.Fes   30.11.2007        Ersterstellung
 set MyApplCurVerInfo=J.Fes   18.12.2007        laufende anpassung
 set MyApplCurVerInfo=J.Fes   05.05.2008        JT Export/Update ergaenzt
 set MyApplCurVerInfo=J.Fes   23.11.2008        StepExport ergaenzt
 set MyApplCurVerInfo=K.Sch   17.08.2011        Umstellung der Eingabeparameter
 set MyApplCurVerInfo=K.Sch   20.09.2011        added CheckMate
 rem Echo  ---------------------------------------------------------------

 set JobMgr_TcUser=%~1
 set JobMgr_TcPw=%~2
 set JobMgr_TcGroup=%~3
 if not defined JobMgr_TcGroup set JobMgr_TcGroup=dba

 rem -- Basiseinstellungen fuer das Verhalten es Scriptes ----------------------
 REM Hier knnen Verschiedene Einstellungen getroffen werden die steuern wie das Script ablaufen soll
 rem      Die mit "#" Gitter eingeschlossenen Variablen werden vom JobServer ersetzt

 REM Alle wichtigen Stellen sind mit ## gekennzeichnset
 REM ##Doc:  steht an allen Dokumentations Stellen
 REM ##ToDo: steht an allen stellen die angepasst werden sollen

 rem Debug: [bei Einzel Test's auf=ON] [sonst auf OFF stellen]
 set JobMgr_Debug=OFF
 rem -- JobScriptParametersExtended:
 rem    Hinweis:"JobScriptParametersExtended" ist nach dem ausfueller der # variablen leer
 rem             wenn das Datenfeld von Script/Param. J.Cmd.ParmExt auch leer ist
 #JobScriptParametersExtended#

 set JobStartDateTime=%Date%/%time:~0,8%

 rem Farbe setzen am Anfang auf IsIdel
 Call :ColorSet IsIdel

 rem #Variablen ersetzungs Abschnitt
 rem Info die mit "#" Gitter eingeschlossenen Vaiablen werden vom JobServer
 rem vor dem senden an den JobClient ersetzt Beispiel: #JobName#
 set JobName=#JobName#
 set JobParameter=#JobParameter#
 set RefilePaket_NE=#RefilePaket_NE#


 set TceSiteId=#TceSiteId#
 set TceUser=#TceUser#
 set TceUserPassword=#TceUserPassword#

 rem -- JobParameter
 set JobPlaner_Param=#JobPlaner_Param#
 set JobPlaner_Name=#JobPlaner_Name#
 set JobOwner=#JobPlaner_Owner#
 set JobObjectsPacket_NE=#JobObjectsPacket_NE#
 set JobObjectsPacketAllDetails_NE=#JobObjectsPacketAllDetails_NE#

 rem JobManager Pathvariablen uebernehmen
 set BinServer_DP=#01-BinServer_DP#
 set BinClient_DP=#02-BinClient_DP#
 set BinPublic_DP=#03-BinPublic_DP#
 set JobScripts_DP=#10-JobScripts_DP#
 set JobComputerScripts_DP=#20-JobComputerScripts_DP#
 set JobLogArchiv=#10-JobLogArchiv#
 set JM_ApplRoot_DP=#00-ApplRoot_DP#
 set JM_DataRoot_DP=#12-Data#
 set JS_DataRoot_CustomWorkInst_DP=#DataRoot_CustomWorkInst_DP#

 rem Allgemeine Variablen des Scriptes zusammensetzen
 set MyCmd=%0
 set MyApplName_TP=#MyApplName_TP#
 set MyApplMainInfo=%MyApplName_TP% %MyApplCurVerInfo%

 rem -- #Step: JobMgr CmdTools local kopieren ----------------------------------
 rem -- #Doc: Steuert aus welchem Bereich die Tools genommen werden J.Fes 14.02.2013
 set JobManagerCmdTools_DP=%JobManagerRoot_DP%\03-BinPublic.ClientServer

 set BinL_DP=%CmdCurRoot_DP%\..\BinL
 if not exist "%BinL_DP%" md "%BinL_DP%"
 Call Echo "TcUser/Group.......: [%JobMgr_TcUser%/%JobMgr_TcGroup%]"
 Call Echo "Upd. JobMgrCmd BinL: [%BinL_DP%]"
 Call Echo "from...............: [%JobManagerCmdTools_DP%]"

 set JobManagerCmdTools_L=%BinL_DP%\JobManagerCmdTools.exe
 set robocopy_opt=/R:5 /W:5
 robocopy %robocopy_opt% /NP /NJS /NJH /NDL /NFL "%JobManagerCmdTools_DP%" "%BinL_DP%" "JobManagerCmdTools.exe">nul 2>nul

 rem new 21.01.2014
 set JFProcessMonitorL_exe=%BinL_DP%\JFProcessMonitor.exe
 robocopy %robocopy_opt% /NP /NJS /NJH /NDL /NFL "%BinPublic_DP%" "%BinL_DP%" "JFProcessMonitor.exe"


 rem initaliesiert die Umgebung
 set myAppl_Title=NXDataExport(Running Init)
 title %myAppl_Title%

 rem PathExtend
 set CurCmdRoot_DP=%~dp0
 set CurCmdRoot_DP=%CurCmdRoot_DP:~0,-1%
 rem suchpath erweitern
 set Path=%CurCmdRoot_DP%;%BinPublic_DP%;%Path%

 Echo.
 Echo **************************************************************************
 Echo * %MyApplMainInfo%                                         *
 Echo * executing PLMJobManager script for:                                    *
 Echo *  - exporting NX Data to: Step / JT / Parasolid / DWG / DXF /           *
 Echo *  - creating or updating JT Files for TcEng                             *
 Echo **************************************************************************

 rem ---------------------------------------------------------
 rem ## TCEPromtCmd organiesieren
 rem - NX5 Ver einstellen
 rem set NXver=NX5   



REM ##ToDo: SetUp Tc Prompt
 if /i "#TceSiteId#" neq "TC8Pilot" goto :JumbOver1 {
   set TcPromtCmd=\\demas0079\ugsshare\start_apps\windows\start_nx75.bat
   set TcPromtCmdOpt=de tc_prompt tc8 tc83 }

 :JumbOver1
 
if /i "#TceSiteId#" neq "TC8_Test" goto :JumbOver1 {
   set TcPromtCmd=\\demas0908\ugsshare\start_apps\windows\start_nx75.bat
   set TcPromtCmdOpt=de tc_prompt tc8 tc83 }

 :JumbOver1

 if     exist "%TcPromtCmd%" call "%TcPromtCmd%" %TcPromtCmdOpt%
 if not exist "%TcPromtCmd%" goto :TCEPromtCmdError

  if /I "%JobMgr_Debug%" equ "ON" (
   pause
 )


REM  rem -- Suchpath angepasst erforderlich da sonst die programme nicht starten koennen Achtung erst Prompt durchlaufen!
REM  set Path=%UGII_BASE_DIR%;%UGII_ROOT_DIR%;%CurCmdRoot_DP%;%BinPublic_DP%;%Path%
REM  set Path=%UGII_BASE_DIR%;%UGII_ROOT_DIR%;%Path%


 set myAppl_Title=NXDataProcessing (%ORACLE_SID%)
 title %myAppl_Title%

 rem !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
 rem Hauptroutine fr den Datenexport via JobManager

 rem ## diesen Path evtl. anpassen. Hinweis siehe subpath=..\_ExportControl..
 set ExportRoot_DP=%JM_DataRoot_DP%\_NxExportData
 if not "%JobOwner%"==""       set ExportRoot_DP=%ExportRoot_DP%\%JobOwner%
 if not "%JobPlaner_Name%"=="" set ExportRoot_DP=%ExportRoot_DP%\%JobPlaner_Name%

 rem ---------------------------------------------------------
 rem temp dir Organiesieren
 if "%temp_DP_org%"=="" set temp_DP_org=%temp%
 set temp=%CurCmdRoot_DP%
 if not exist "%temp%" md "%temp%"

 rem Echo %myAppl_Title%
 Echo ------------------------------------------------------------------------
 Echo JobInfo:       : %myAppl_Title%
 Echo ------------------------------------------------------------------------
 Echo JobOwner       : %JobOwner%
 Echo JobName        : %JobName%
 Echo Computer       : %ComputerName%
 Echo TceSide        : %TceSiteId%
 Echo TceUser        : %TceUser%
 Echo.
 Echo JobDir         : %temp%
 Echo JobParameter   : %JobParameter%
 Echo Start time     : %JobStartDateTime%
 Echo.
 Echo Export Parameter:
 Echo StepExport     : %StepExport%
 Echo JT Export      : %JTExport%
 Echo JT TceUpdate   : %JTTCUpdate%
 Echo ParasolidExport: %ParasolidExport%
 Echo DXFExport      : %DXFExport%
 Echo DWGExport      : %DWGExport%
 Echo CheckMate      : %CheckMate%
 Echo ------------------------------------------------------------------------
 Echo.
  if /I "%JobMgr_Debug%" equ "ON" (
   pause
 )

 rem -- JT Update TC Singleparts
 IF /i "%JTTCUpdate%" equ "true" call "NXDataProcessing_JTTc.cmd"


  if /I "%JobMgr_Debug%" equ "ON" (
   pause
 )
 rem hier ist das Ende des Ablaufes
 rem alle nicht erforderlichen Dateien aus den TempVerzeichnissn leschen
 del %temp%\*.jnl,%temp%\mapping_file_errors.txt,%temp%\apiserver.exe*,%temp%\*.prt /s /q>nul
 rem am Ende
 set temp=%temp_DP_org%
 cd /d "%temp_DP_org%"
 set JobEndDateTime=%Date%/%time:~0,8%
 Echo Job: %JobName% beendet %JobEndDateTime%

 Echo ---------------------------------------------------
 rem und die farben wieder zurueckstellen
 Call :ColorSet End

 if /I "%JobMgr_Debug%" equ "ON" (
   pause
 )
goto :eof

:CheckResult
 rem Aufgabe:
 rem suche ob es zu jedem Eintrag in %JobObjectsPacketAllDetails_DPNE%
 rem ein Ergebniss %JobProcessResultLog_DPNE% in enthalten ist

 FOR /F "skip=1 delims=" %%i in (%JobObjectsPacketAllDetails_DPNE%) do call :CheckResultDo "%%i"
 call :SendInfoMail
 goto :eof

:CheckResultDo
 setlocal
   rem prueft ob es fr den %ObjectCliName% ein Ergebnis in "%JobProcessResultLog_DPNE%" gefunden werden kann
   rem wenn nicht dann wird -100 alles Ergebniss zureck gegeben

   call :DataSetSplit %1

   set AddToNotProssed=false
   set ResultText=No Export was done for this Object

   Echo such in: "%JobProcessResultLog_DPNE%"
   Echo nach     %ObjectCliName%

   rem if not exist "%JobProcessResultLog_DPNE%" set AddToNotProssed=true& goto :next

   findstr /c:"%ObjectCliName%" "%JobProcessResultLog_DPNE%" >nul 2>nul
   set ObjectCliFound_inJobLog=%errorlevel%
   if not "%ObjectCliFound_inJobLog%"=="0" set AddToNotProssed=true
   rem Echo  ObjectCliFound_inJobLog=%ObjectCliFound_inJobLog%
   rem pause

   :next
   if /i "%AddToNotProssed%"=="true" (
      rem Object zu NotProcessd hinzufgen
      call :JobResultsGenericV1_WriteLog  "%ObjectCliName%" "-100" "%ResultText%" "" %ItemName% %RevName%
   ) ELSE (
      Type "%JobProcessResultLog_DPNE%"
   )
 endlocal
 goto :eof

:SendInfoMail
 setlocal
   set eMailAdress=JFes@PLMJobManager.com
   set MailSubjText=-s "JobMgr:%myAppl_Title% JobID:%JobPlaner_Name%"

   rem set server=-server localhost
   set MailServer=-server JF-18
   set MailBodyText_DPNE=%Temp%\zzMailBodyText.txt
   set MailSendLog=%Temp%\zzMailSendLog.txt

   call :ExportFileDest_DP_gen ExportDest_DP PrtDest_DP
   if not exist "%ExportDest_DP%" md "%ExportDest_DP%"
   set JobEndeDateTime=%Date%/%time:~0,8%
   rem Mail Body zusammensetzen

   Echo Hallo %JobOwner%>>"%MailBodyText_DPNE%"
   Echo.>>"%MailBodyText_DPNE%"
   Echo Info Mail vom PLMJobManager>>"%MailBodyText_DPNE%"
   Echo JobID........: %JobPlaner_Name%>>"%MailBodyText_DPNE%"
   Echo JobType......: NX-Export>>"%MailBodyText_DPNE%"
   Echo JobParameter.: %JobPlaner_Param%>>"%MailBodyText_DPNE%"
   Echo.>>"%MailBodyText_DPNE%"
   Echo JobComputer..: \\%ComputerName%>>"%MailBodyText_DPNE%"
   Echo JobStart.....: %JobStartDateTime%>>"%MailBodyText_DPNE%"
   Echo JobEnde......: %JobEndeDateTime%>>"%MailBodyText_DPNE%"
   Echo.>>"%MailBodyText_DPNE%"
   Echo JobResult....: Files wurden in das folgende Verzeichnis exportiert:>>"%MailBodyText_DPNE%"
   Echo          ....: %ExportDest_DP%>>"%MailBodyText_DPNE%"
   Echo.>>"%MailBodyText_DPNE%"
   Echo Info:>>"%MailBodyText_DPNE%"
   Echo ----->>"%MailBodyText_DPNE%"
   Echo Diese Mail wurde mit dem PLMJobManager automatisch erstellt.>>"%MailBodyText_DPNE%"
   rem Type "%MailBodyText_DPNE%"

   rem set x=-x "X-Header-Test: Can Blat do it? Yes it Can!"
   set debug=-debug -log "%MailSendLog%" -timestamp
   rem ::::::::::::::::: Now we run Blat!  :::::::::::::::::
   rem set toRun=blat "%MailBodyText_DPNE%" -to %eMail% -f %eMail% %subj% %server% %debug% %x%
   set toRun=blat "%MailBodyText_DPNE%" -to %eMailAdress% -f %eMailAdress% %MailSubjText% %MailServer% %debug%
   rem Echo %toRun%
   %toRun% >nul 2>nul

 endlocal
 goto :eof

rem ----------------------------------------------------------------------------
rem !! CheckMate for SP!!
rem ----------------------------------------------------------------------------
:CheckMateSp
   set CurActionTitle=CheckMate[SP]

   rem Printausgabe
   Call Echo  "%CurActionTitle% start"
   type "%ExportListNXMasterSP_DPNE%"
   
   
   call :CheckMakeSetEnviron

   set toRunInfo_DPNE=%temp%\_Job_%CurActionTitle%_log.txt

   rem - Customer Script 
   
   rem CheckMate
   set toRun="%UGII_BASE_DIR%\DESIGN_TOOLS\checkmate\ug_check_part" -pim=yes -u=%TceUser% -p=%TceUserPassword%
   set JobParameter=-checker "CRI_ASSY_TEST_001"
   set JobParameter=%JobParameter% -output_file "%temp%\check.log"
   set JobParameter=%JobParameter% -log_dir "%temp%"
   set JobParameter=%JobParameter% -option_file "%ExportListNXMasterSP_DPNE%"

   
   rem complete the programm with jobparamter
   set toRun=%toRun% %JobParameter%

   echo %toRun%>>%toRunInfo_DPNE%
   
   
   rem for /d %%i in (%toRun%) do Echo ToRun: %%i

   rem -- start Customer GEN --
   %toRun%
   echo %ExportControlListNXMasterSp_DPNE%
   
   rem -- check Results
   FOR /F "tokens=1,2,3,4 delims=;" %%i in (%ExportControlListNXMasterSp_DPNE%) do call :CheckMateresults "%%i" "%%j" "%%k" "%%l" "SP"
   rem Printausgabe
   Call Echo  "%CurActionTitle% end"
 goto :eof

 
rem ----------------------------------------------------------------------------
rem !! CheckMate for AP!!
rem ----------------------------------------------------------------------------
:CheckMateAp
   set CurActionTitle=CheckMate[Ap]

   rem print title
   Call Echo  "%CurActionTitle% start"
   type "%ExportListNXMasterAP_DPNE%"
   
   
   call :CheckMakeSetEnviron

   set toRunInfo_DPNE=%temp%\_Job_%CurActionTitle%_log.txt

   rem - Customer Script 
   
   rem CheckMate
   set toRun="%UGII_BASE_DIR%\DESIGN_TOOLS\checkmate\ug_check_part" -pim=yes -u=%TceUser% -p=%TceUserPassword%
   set JobParameter=-checker "CRI_ASSY_TEST_001"
   set JobParameter=%JobParameter% -output_file "%temp%\check.log"
   set JobParameter=%JobParameter% -log_dir "%temp%"
   set JobParameter=%JobParameter% -option_file "%ExportListNXMasterAP_DPNE%"

   
  rem complete the programm with jobparamter
   set toRun=%toRun% %JobParameter%

   echo %toRun%>>%toRunInfo_DPNE%
   
   
   rem for /d %%i in (%toRun%) do Echo ToRun: %%i

   rem -- start Customer GEN --
   %toRun%

   rem -- check Results
   FOR /F "tokens=1,2,3,4 delims=;" %%i in (%ExportControlListNXMasterAP_DPNE%) do call :CheckMateresults "%%i" "%%j" "%%k" "%%l" "AP"

   rem print title
   Call Echo  "%CurActionTitle% end"
 goto :eof 
 
 
 
 
rem ---------------------------------------------------------------------------------
:CheckMateresults
   rem erstellt die Ergebnissdatei
   setlocal

     set ItemName=%1
     set RevName=%2
     set ObjectCliName=%3
     set ExpoType=%5

     rem strip '"'
     set ItemName=%ItemName:"=%
     set RevName=%RevName:"=%
     set ObjectCliName=%ObjectCliName:"=%

     set ExpoType=%ExpoType:"=%
	
	 rem rename log_file and set log_file
	 
	 rename %temp%\%ItemName%_%RevName%* %ItemName%_%RevName%.xml
	
	 
	 set CHgenLog_DPNE=%temp%\%ItemName%_%RevName%.xml
   
	 

     rem check is the logfile exist
     if     exist "%CHgenLog_DPNE%" goto :CheckMate_CheckResult
     if not exist "%CHgenLog_DPNE%" goto :CheckMate_LogErr

     :CheckMate_CheckResult

	 
	 
	 
	 rem Auswerten der Ergebnisse aus den Logfiles
     rem Achtung Reihenfolge:
     rem -- hier folgen die Auswertungen die einen Fehler reporten  
     findstr /c:"fail" "%CHgenLog_DPNE%">>"%toRunInfo_DPNE%"
     set CHExpoErrLevel=%errorlevel%
     if "%CHExpoErrLevel%"=="0" goto :CheckMate_CreateCHErr

     
	 rem -- hier folgen die Auswertungen die einen Fehler reporten  
     findstr /c:"pass" "%CHgenLog_DPNE%">>"%toRunInfo_DPNE%"
     set CHExpoErrLevel=%errorlevel%
     if  "%CHExpoErrLevel%"=="0" goto :CheckMate_CreateCHOk
	 
	      

     rem -- wenn jetzt Fehler vorhanden da kein OK gefunden wurde zur Error auswertung gehen
     if not "%CHExpoErrLevel%"=="0" goto :CheckMate_CreateCHErr

      :CheckMate_CreateCHOk
       rem --- schreiben der Ergebnisse in den Ergebnisfile
       call :JobResultsGenericV1_WriteLog  "%ObjectCliName%" "0" "CheckMate:OK" "" %ItemName% %RevName%
       goto :MyEnde

      :CheckMate_CreateCHErr
       rem --- schreiben der Ergebnisse in den Ergebnisfile
       call :JobResultsGenericV1_WriteLog  "%ObjectCliName%" "100" "CheckMate:Err" "" %ItemName% %RevName%
       goto :MyEnde
	   
	   
	   :CheckMate_LogErr
       rem --- schreiben der Ergebnisse in den Ergebnisfile
       call :JobResultsGenericV1_WriteLog  "%ObjectCliName%" "1000" "CheckMate:Err LOGFILE" "" %ItemName% %RevName%
       goto :MyEnde

      :MyEnde
   endlocal
 goto :eof

 
 
rem ---------------------------------------------------------------------------------
:CheckMakeSetEnviron
   rem -- setz fuer alle CheckMate  Vorgaenge die Umgebung ein
   rem Default Files festlegen
   set UGII_LOAD_OPTIONS=%CurCmdRoot_DP%\load_options_DataExport.def
  
   set temp=%temp%\CheckMate

   if not exist "%temp%" md "%temp%"
   cd /D "%temp%"
  
   set CMFile_LP=%temp%\CMFiles
   if not exist "%CMFile_LP%" md "%CMFile_LP%"
   cd /D "%CMFile_LP%"
   
  
   rem NX Umgebung einstellen
   call :NxSetEnvironForExport

 goto :eof




rem ---------------------------------------------------------------------------------
:AddToList
 rem Addiert eine Element an die Liste
 rem " replace

 Call :DataSetSplit %1

 set INPUT_PARTS_LIST=%INPUT_PARTS_LIST%,%ObjectCliName%
 set OUTPUT_PARTS_LIST=%OUTPUT_PARTS_LIST%,%ItemNameNoBlanks%_%RevNameNoBlanks%.prt

 goto :eof

rem ---------------------------------------------------------------------------------
:excec
 %*
 goto :eof

rem ---------------------------------------------------------------------------------
:DataSetSplit
 rem Splittet einen JobMgr AllDetails Datensatzes auf

 rem vorne und hinten " abscheiden
 set ObjectInfoLine01=%1
 set ObjectInfoLine01=%ObjectInfoLine01:~1,-1%

 rem Objektdaten extrahieren nach dem 31 ";"
 FOR /F "tokens=31,* delims=;" %%i IN ("%ObjectInfoLine01%") do set ObjectInfoLine32=%%j

 FOR /F "tokens=1 delims=;"  %%i IN ("%ObjectInfoLine01%") do set ItemName=%%i
 FOR /F "tokens=2 delims=;"  %%i IN ("%ObjectInfoLine01%") do set RevName=%%i
 FOR /F "tokens=4 delims=;"  %%i IN ("%ObjectInfoLine01%") do set IrCli=%%i

 FOR /F "tokens=5 delims=;"  %%i IN ("%ObjectInfoLine01%") do set ObjectCliNameForFileSys=%%i
 FOR /F "tokens=9 delims=;"  %%i IN ("%ObjectInfoLine01%") do set PartType=%%i
 FOR /F "tokens=10 delims=;" %%i IN ("%ObjectInfoLine01%") do set ObjectCliName=%%i

 FOR /F "tokens=12 delims=;" %%i IN ("%ObjectInfoLine01%") do set ObjectOwner=%%i
 FOR /F "tokens=13 delims=;" %%i IN ("%ObjectInfoLine01%") do set Group=%%i
 FOR /F "tokens=15 delims=;" %%i IN ("%ObjectInfoLine01%") do set ObjectLastModUser=%%i

 FOR /F "tokens=17 delims=;" %%i IN ("%ObjectInfoLine01%") do set PartTypeSpAp=%%i
 FOR /F "tokens=18 delims=;" %%i IN ("%ObjectInfoLine01%") do set CompCount=%%i
 FOR /F "tokens=21 delims=;" %%i IN ("%ObjectInfoLine01%") do set ObjectFs_DPNE=%%i
 FOR /F "tokens=22 delims=;" %%i IN ("%ObjectInfoLine01%") do set Volume=%%i

 Rem Special Variablen ..NoBlanks
 set ItemNameNoBlanks=%ItemName: =%
 call :ReplaceInvalidChar ItemNameNoBlanks "%ItemNameNoBlanks%"
 set RevNameNoBlanks=%RevName: =%
 call :ReplaceInvalidChar RevNameNoBlanks "%RevNameNoBlanks%"

 if /I "%2"=="Print" call :DataSetCurrPrint
 goto :eof

:DataSetCurrPrint
 Echo IrCli        : %IrCli%
 Echo ItemName     : %ItemName%
 Echo RevName      : %RevName%
 Echo ObjectCliName: %ObjectCliName%

 Echo ItemNameNoBlanks : %ItemNameNoBlanks%
 Echo RevNameNoBlanks  : %RevNameNoBlanks%

 goto :eof


rem ---------------------------------------------------------------------------------
:DataSetsSepToLists

  Echo #toDo: 05.09.2013 ersetzen durch  JobManagerCmdTools.exe

 rem verteilt die Datasets auf die jeweiligen Listen Master Sp Master Ap und DXF
 set /A ObjectNr=%ObjectNr%+1
 call :DataSetSplit %1

 rem ## MaxComp evtl. anpassen !!
 set ApMaxComp=140000

 call JobManagerCmdTools.exe

 if /I "%PartType%"=="UGMASTER" goto :AddToNXMasterList
 if /I "%PartType%"=="UGPART"   goto :AddToDXFList
                                goto :AddToNoExportList


 :AddToNXMasterList
  rem %CompCount% bercksichtigen ??
  if /I "%PartTypeSpAp%"=="SP" goto :AddToNXMasterListSP
  if /I "%PartTypeSpAp%"=="AP" goto :AddToNXMasterListAP
                               rem wenn keine SP AP dann AddTONoExportList
                               goto :AddToNoExportList

  :AddToNXMasterListSP
   rem zuordnung zu NXMaster SP Liste
   echo %IrCli%>>"%ExportListNXMasterSP_DPNE%"
   echo %ItemName%;%RevName%;%ObjectCliName%;%PartTypeSpAp%;%PartType%;%DataSetName%;%IrCli%>>"%ExportControlListNXMasterSp_DPNE%"
   echo %ObjectInfoLine01%>>"%ExportControlListNXMasterSpAllDetails_DPNE%"
   echo %ObjectCliName%=[NXMaster:SP]
   goto :eof


  :AddToNXMasterListAP
   rem zuordnung zu NXMaster AP Liste
   echo %IrCli%>>"%ExportListNXMasterAP_DPNE%"
   echo %ItemName%;%RevName%;%ObjectCliName%;%PartTypeSpAp%;%PartType%;%DataSetName%;%IrCli%>>"%ExportControlListNXMasterAP_DPNE%"
   echo %ObjectInfoLine01%>>"%ExportControlListNXMasterApAllDetails_DPNE%"
   echo %ObjectCliName%=[NXMaster:AP]
   goto :eof


  :AddToDXFList
   if %CompCount% GTR %ApMaxComp% goto :AddToNoExportList
   echo %ItemName%;%RevName%;%ObjectCliName%;%PartTypeSpAp%;%PartType%;%DataSetName%>>"%DxfDwgExportList_DPNE%"
   echo %ObjectInfoLine01%>>"%DxfDwgExportListAllDetails_DPNE%"
   echo %ObjectCliName%=[DxfDwgDrawing]
   goto :eof


 :AddToNoExportList
   rem weder UGMASTER noch UGPART also auf die NoExportList
   echo %ItemName%;%RevName%;%ObjectCliName%;%PartTypeSpAp%;%PartType%;%DataSetName%>>"%NoExportList_DPNE%"
   call :JobResultsGenericV1_WriteLog  "%ObjectCliName%" "0" "No-Expo: do not export this Dataset" "" %ItemName% %RevName%
   echo %ObjectCliName%=[Not to Export]
   goto :eof


 goto :eof


rem ---------------------------------------------------------------------
:NxSetEnvironForExport
 rem ## evtl. Suchpath angepasst erforderlich da sonst der refile nicht startet
 rem set Path=%UGII_BASE_DIR%;%UGII_ROOT_DIR%;%Path%

 rem -- UG-Variablen umbiegen --
 set UGII_TMP_DIR=%temp%

 rem LoadOptions setzen
 rem Hinweis: wenn %ExpoSpApType% gesetzt ist dann wird der entsprechende LoadOption File genommen!!
 set UGII_LOAD_OPTIONS=%CurCmdRoot_DP%\load_options_DataExport.def
 if exist %CurCmdRoot_DP%\load_options_DataExport_%ExpoSpApType%.def set UGII_LOAD_OPTIONS=%CurCmdRoot_DP%\load_options_DataExport_%ExpoSpApType%.def

 rem UGMGR_StructureUpdateOnLoad .. onSave = off
 rem ## nur bis NX2
 rem set UGII_DEFAULTS_FILE=%CurCmdRoot_DP%\ug_metric_UGMGR_StructureUpdateOnLoadOnSafe_OFF.def


 set UGII_UGMGR_USE_CACHE=
 set UGII_DISABLE_PREVIEW=on
 set UGII_DISABLE_QAF_NAMED_REFS=on

 rem -- IMAN-Variablen umbiegen --
 rem SET IMAN_SQL_DEBUG=
 set IMAN_TMP_DIR=%temp%
 SET IMAN_KEEP_SYSTEM_LOG=TRUE
 SET UGII_KEEP_SYSTEM_LOG=TRUE
 goto :eof


rem ----------------------------------------------------------------------------
rem !! Parasolid Export !!
rem ----------------------------------------------------------------------------
:ParaSolidExport

 setlocal
  rem P1 = ExportControlListIn_DPNE
  set ExportControlListIn_DPNE=%1
  set ExportControlListIn_DPNE=%ExportControlListIn_DPNE:~1,-1%
  rem P2 = ExportType uebernehmen
  set ExpoSpApType=%2

  set CurActionTitle=ParaSolidExport[%ExpoSpApType%]
  rem Printausgabe
  Call Echo  "%CurActionTitle% start"

  set ParaSolidExpo_DP=%temp%\_ParaSolidExpo
  if not exist "%ParaSolidExpo_DP%" md "%ParaSolidExpo_DP%"
  set temp=%ParaSolidExpo_DP%

  set toRunInfo_DPNE=%temp%\_Job_%CurActionTitle%_log.txt

  rem ParaSolid Dateien exportieren lassen
  FOR /F "delims=" %%i in (%ExportControlListIn_DPNE%) do call :ParaSolidExportDoRun "%%i"

  rem Liste der Exportierten Daten mitschreiben
  Dir /N /O:n "%ParaSolidExpo_DP%\*.x_t">>"%toRunInfo_DPNE%" 2>nul

  rem Exportierte ParaSolid Dateien in die Zielverzeichnisse uebertragen Info:hier werden auch die Ergebnisse erstellt
  FOR /F "delims=" %%i in (%ExportControlListIn_DPNE%) do call :ParaSolidExport_MovePartToArchiv "%%i"

  rem Printausgabe
  Call Echo  "%CurActionTitle% end"

 endlocal
 goto :eof

rem ----
:ParaSolidExportDoRun
   rem erzeut einen ParaSolidFile
  setlocal

   Call :DataSetSplit %1

   rem entfernt einen bereits laufenden ApiServerProzess
   call "%BinPublic_DP%\ApiServerKill.cmd"

   rem NX Umgebung einstellen
   call :NxSetEnvironForExport

   rem toRun .. fuer UG to ParaSolid zusammensetzen
   Call :ParaSolidExportSetFileNames

   set toRun=
   set toRun=%toRun% "%JobScripts_DP%\NxTools\ParasExpo.exe"
   set toRun=%toRun% -part=%IrCli%
   set toRun=%toRun% -Layer=1,101
   set toRun=%toRun% -ExpoType=%ExpoSpApType%
   set toRun=%toRun% -asInfoFile="%asInfoFile_DPNE%"
   set toRun=%toRun% -paraSolidOutPutFile="%ParaSolidExpoFile_DPNE%"
   set toRun=%toRun% -pim -u=%TceUser% -p=%TceUserPassword%

   echo %toRun%>>%toRunInfo_DPNE%
   %toRun%

  endlocal

 goto :eof
 rem -------------------------

:ParaSolidExportSetFileNames
 rem setzt die ParaSolidExpoFile Namen zusammen Info: es werden die aktuell gesetzten %ItemName%_%RevName% var's verwendet
 set ParaSolidFile_NE=%ItemName%_%RevName%_%ExpoSpApType%.x_t
 set ParaSolidExpoFile_DPNE=%ParaSolidExpo_DP%\%ParaSolidFile_NE%
 set asInfoFile_DPNE=%ParaSolidExpo_DP%\%ItemName%_%RevName%_%ExpoSpApType%.NX_AssemblyStructureFirstLevel_list.txt
 goto :eof


:ParaSolidExport_MovePartToArchiv

  rem schiebt die exportierte ParaSolid Datei in das Zielverzeichnis
  setlocal

   call :DataSetSplit %1
   call :ParaSolidExportSetFileNames

   if     exist "%ParaSolidExpoFile_DPNE%" goto :ParaSolidFile_MoveToArchiv
   if not exist "%ParaSolidExpoFile_DPNE%" goto :ParaSolidFileExportRun_ParaSolidFileExpoErr

   :ParaSolidFile_MoveToArchiv

    rem Zielverzeichnis des ParaSolidFile Files
    call :ExportFileDest_DP_gen ParaSolidFile_Dest_DP ParaSolidDest_DP
    rem Zieldateiname des ParaSolidFile Files inc ExpoType also _SP oder _AP
    set ParaSolidFile_Dest_NE=%ItemName%_%RevName%_%ExpoSpApType%.x_t
    set ParaSolidFile_Dest_DPNE=%ParaSolidFile_Dest_DP%\%ParaSolidFile_Dest_NE%

    rem Zielverzeichnis erzeugen
    if not exist "%ParaSolidFile_Dest_DP%" md "%ParaSolidFile_Dest_DP%">>"%toRunInfo_DPNE%"
    set ParaSolidFileExpoErrLevel=%errorlevel%
    if not exist "%ParaSolidFile_Dest_DP%" goto :ParaSolidFileExportRun_CreatePathErr

    rem ParaSolidFile Datei in das Verzeichnis verschieben
    Echo moving: Exported ParaSolidFile File [%ItemName%/%RevName%]
    Echo from: %ParaSolidExpoFile_DPNE%
    Echo   to: %ParaSolidFile_Dest_DPNE%

    move /Y "%ParaSolidExpoFile_DPNE%" "%ParaSolidFile_Dest_DPNE%">>"%toRunInfo_DPNE%"
    set ParaSolidFileExpoErrLevel=%errorlevel%

    if not "%ParaSolidFileExpoErrLevel%"=="0" goto :ParaSolidFile_MoveToArchivErr
    if     exist "%ParaSolidFile_Dest_DPNE%"  goto :ParaSolidFile_MoveToArchivOK
    if not exist "%ParaSolidFile_Dest_DPNE%"  goto :ParaSolidFile_MoveToArchivErr

    :ParaSolidFile_MoveToArchivOK
     rem --- schreiben der Ergebnisse in den Ergebnisfile
     Set ResultText=ParaSolid-Expo:OK %ParaSolidFile_Dest_DPNE%
     Echo %ResultText%>>"%toRunInfo_DPNE%"
     call :JobResultsGenericV1_WriteLog  "%ObjectCliName%" "0" "%ResultText%" "" %ItemName% %RevName%
     goto :ParaSolidFile_MoveToArchivEnde

    :ParaSolidFileExportRun_ParaSolidFileExpoErr
     rem --- schreiben der Ergebnisse in den Ergebnisfile
     Set ResultText=ParaSolid-Expo:Err ParaSolidFile file:[%ParaSolidFile_NE%] cound not be exported
     Echo %ResultText%>>"%toRunInfo_DPNE%"
     call :JobResultsGenericV1_WriteLog  "%ObjectCliName%" "100" "%ResultText%" "" %ItemName% %RevName%
     goto :ParaSolidFile_MoveToArchivEnde

    :ParaSolidFileExportRun_CreatePathErr
     rem --- schreiben der Ergebnisse in den Ergebnisfile
     Set ResultText=ParaSolid-Expo:Err [OS:%ParaSolidFileExpoErrLevel%] user %userName% creating path [%ParaSolidFile_Dest_DP%]
     Echo %ResultText%>>"%toRunInfo_DPNE%"
     call :JobResultsGenericV1_WriteLog  "%ObjectCliName%" "110" "%ResultText%" "" %ItemName% %RevName%
     goto :ParaSolidFile_MoveToArchivEnde

    :ParaSolidFile_MoveToArchivErr
     rem --- schreiben der Ergebnisse in den Ergebnisfile
     Set ResultText=ParaSolid-Expo:Err [OS:%ParaSolidFileExpoErrLevel%] moving part to:[%ParaSolidFile_Dest_DPNE%]
     Echo %ResultText%>>"%toRunInfo_DPNE%"
     call :JobResultsGenericV1_WriteLog  "%ObjectCliName%" "120" "%ResultText%" "" %ItemName% %RevName%
     goto :ParaSolidFile_MoveToArchivEnde

   :ParaSolidFile_MoveToArchivEnde

  endlocal
 goto :eof



rem ----------------------------------------------------------------------------
rem ----------------------------------------------------------------------------
:ExportFileDest_DP_gen

 rem setzt den Verzeichnissnamen fr die Exportverzeichnisse zusammen
 rem P1=Variable ffuer die bergabe des Zielverzeichniss des Export Verzeichnisses
 rem P2=PrtDest_DP

 call :ReplaceInvalidChar ItemName_l "%ItemNameNoBlanks%"
 call :ReplaceInvalidChar RevName_l "%RevNameNoBlanks%"

 set LastPathExtend_l=

 rem ## Anpassen: Exportzielverzeichnisse festlegen!
 rem    Hinweis: %ExportRoot_DP% wird im Standard von den einstellungen des JobMgr uebernommen
 rem set %1=%ExportRoot_DP%\%ItemName_l:~0,3%\%ItemName_l:~0,6%\%ItemName_l%\%ItemName_l%_%RevName_l%_%LastPathExtend_l%
 rem set %1=%ExportRoot_DP%\%ItemName_l:~0,5%\%ItemName_l%_%RevName_l%
 rem Var 1
 rem set %1=%ExportRoot_DP%\%ItemName_l:~0,5%
 rem set %2=%ExportRoot_DP%_saved_2d_PrtFiles\%ItemName_l:~0,5%\%ItemName_l%_%RevName_l%

 rem Var 2 erstellt 10.5.09
 set %1=%ExportRoot_DP%\%ItemName_l%_%RevName_l%
 set %2=%ExportRoot_DP%_saved_2d_PrtFiles\%ItemName_l%_%RevName_l%

 rem Var 3 erstellt 10.5.09
 set %1=%ExportRoot_DP%
 set %2=%ExportRoot_DP%_saved_2d_PrtFiles


 set ItemName_l=
 set RevName_l=
 set LastPathExtend_l=

 goto :eof



rem ------------------------------------------------------------------
rem ------------------------------------------------------------------

:ReplaceInvalidChar
 setlocal
     rem entfernt alle unzulaessigen Zeichen
     set ReplaceInvalidChar=%2
     set ReplaceInvalidChar=%ReplaceInvalidChar:~1,-1%
     set ReplaceInvalidChar=%ReplaceInvalidChar:-=_%
     rem \ durch _ ersetzen
     set ReplaceInvalidChar=%ReplaceInvalidChar:\=_%
     rem / durch _ ersetzen
     set ReplaceInvalidChar=%ReplaceInvalidChar:/=_%
     rem . durch _ ersetzen
     set ReplaceInvalidChar=%ReplaceInvalidChar:.=_%
     rem " " durch _ ersetzen
     set ReplaceInvalidChar=%ReplaceInvalidChar: =_%

     rem "-" durch _ ersetzen
     set ReplaceInvalidChar=%ReplaceInvalidChar:-=_%

     rem " " durch _ ersetzen
     set ReplaceInvalidChar=%ReplaceInvalidChar:^*=_%
     rem Echo VarName %1 Wert %2 wird zu %ReplaceInvalidChar%
     rem Echo ReplaceInvalidChar=%ReplaceInvalidChar%
     rem pause
 endlocal& set %1=%ReplaceInvalidChar%
 goto :eof

rem ------------------------------------------------------------------

rem ------------------------------------------------------------------
:PrintCurrAction
 rem Ausgabe ber aktuelle Aktion
 rem P1 = AktionInfo
 Set CurrInfo=%myAppl_Title% %1 [%Date:~0,6%%Date:~8,2% %Time:~0,5% %JobName%]
 Title %CurrInfo%
 Echo --------------------------------------------------------------------
 Echo Aktion  : %1 (%Date:~0,6%%Date:~8,2% %Time:~0,5%)
 Echo JobName : %JobName%
 Echo --------------------------------------------------------------------
 goto :eof

:PrintResultMsg
 rem Ausgabe des aktuellen Ergebnisses
 rem P1 = AktionInfo
 setlocal
   set timePrint=%Time:~0,5%
   set timePrint=%timePrint: =0%
   Set CurrInfo=%2 [%Date:~0,6%%Date:~8,2% %timePrint% %JobName%]
   Title %myAppl_Title% Result:%CurrInfo%
   Banner.exe "%1:%timePrint%"
   Echo Result:%CurrInfo%
 endlocal
 goto :eof


rem ------------------------------------------------------------------
:LogFileGen
 rem P1=Varname auf den der LogfileName bergeben wird
 rem P2=Pre/Post ..
 set %1=%temp%\%2.TXT
 goto :eof

:LogFileGenTempOrig
 rem P1=Varname auf den der LogfileName bergeben wird
 rem P2=Pre/Post ..
 set %1=%temp_DP_org%\%2.TXT
 goto :eof


rem ##### ----------- NXDataExport SUBroutines ------------------ ######
rem -----------------------------------------------------------------------
:TCEPromtCmdError
 set ErrLog_DPNE=%temp%\__Err_MissingTcePromtCmd_DeaktivateComputer.txt
 set title_str=ERR: !! cannot start Job on:\\%ComputerName% missing TCEPromptCmd [%Date%/%time:~0,8%] !!
 title %title_str%
 Echo ---------------------------------------------------------------------
 call :ErrLogHeaderWrite
 Echo %title_str%>>"%ErrLog_DPNE%"
 Echo TCEPromtCmd:=%TCEPromtCmd%>>"%ErrLog_DPNE%"

 Type "%ErrLog_DPNE%"
 call :ErrLogFooterWrite
 Echo.
 Echo after press enter you will see the error reason in notepad editor ....
 pause
 start " " Notepad.exe "%ErrLog_DPNE%"
 pause
 goto :end



:ErrLogHeaderWrite
 rem schreibt die erweiterten Infos an einen ErrLogFile
 rem Info: die Variable ErrLog_DPNE muss gesetzt sein!!
 Echo JobClient Error Report  created %date% %time%>>"%ErrLog_DPNE%"
 Echo Computer: %ComputerName% >>"%ErrLog_DPNE%"
 Echo User:     %UserName% >>"%ErrLog_DPNE%"
 Echo --------------------------------------------------------------------->>"%ErrLog_DPNE%"
 goto :eof


:ErrLogFooterWrite
 rem schreibt die erweiterten Infos an einen ErrLogFile
 rem Info: die Variable ErrLog_DPNE muss gesetzt sein!!
 Echo.>>"%ErrLog_DPNE%"
 Echo --------------------------------------------------------------------->>"%ErrLog_DPNE%"
 Echo Environ Info of:\\%ComputerName%>>"%ErrLog_DPNE%"
 Echo.>>"%ErrLog_DPNE%"
 Echo -- Path Environ ----------------------------------------------------->>"%ErrLog_DPNE%"
 set PATH>>"%ErrLog_DPNE%"

 Echo -- UG* Environ ------------------------------------------------------>>"%ErrLog_DPNE%"
 set UG>>"%ErrLog_DPNE%"
 Echo -- IMAN* Environ ---------------------------------------------------->>"%ErrLog_DPNE%"
 set IMAN>>"%ErrLog_DPNE%"
 Echo -- All Environ ------------------------------------------------------>>"%ErrLog_DPNE%"
 set>>"%ErrLog_DPNE%"
 goto :eof

:end
 Echo ---------------------------------------------------------------------
 Echo Info:
 Echo all files in: %temp%
 Echo will be zipt by JobClient and send to JobServer


rem #################################################################################
rem ########## ------------ Standard Subroutines --------------------- ##############

rem ----------------------------------------------------------------------------
:ColorSet
 rem -- cmd Color Farbinfo:
 REM    0 = Schwarz        8 = Dunkelgrau
 REM    1 = Dunkelblau     9 = Blau
 REM    2 = Dunkelgrn     A = Grn
 REM    3 = Blaugrn       B = Zyan
 REM    4 = Dunkelrot      C = Rot
 REM    5 = Lila           D = Magenta
 REM    6 = Ocker          E = Gelb
 REM    7 = Hellgrau       F = Wei

 rem -- Farben nach Status setzen
 rem Gelb Schwarz
 if /I "%1"=="IsExecuting" set JobColorLast=E0
 rem Gelb Schwarz
 if /I "%1"=="IsIdel"      set JobColorLast=E0
 rem Hellgrau Schwarz
 if /I "%1"=="End"         set JobColorLast=70
 if /I "%1"=="Ende"        set JobColorLast=70
 rem Gruen Schwarz
 if /I "%1"=="Ok"          set JobColorLast=A0
 rem Rot Schwarz
 if /I "%1"=="Err"         set JobColorLast=C0

 rem jetzt die Farbe setzen
 if not "%JobColorLast%"=="" color %JobColorLast%
 goto :eof

rem ---------------------------------------------------------------------------------
:ObjectToProcessCound
 rem hochzhlen des Anzahlzhlers
 set /A ObjectsToProcessN=%ObjectsToProcessN%+1
 rem Echo Cli:%ObjectCliName% PartType:%PartTypeSpAp%
 goto :eof




rem -----------------------------------------------------------------------
:PathCutLastDir
 rem schneidet das letzte Verzeichnis Uebergeben path ab
 rem P1 = Name der Variablen
 rem P2 = der bergebene Path
 rem Example : call :PathCutLastDir EntwRoot_LP %~dp0
 rem Example : call :PathCutLastDir MyVar %~dp0

 set PathCutLastDir$temp=%2
 set PathCutLastDir$tempLastChar=%PathCutLastDir$temp:~-1%
 set PathCutLastDir$tempNoBacks=%PathCutLastDir$temp:~0,-1%

 if "%PathCutLastDir$tempLastChar%"=="\" (
   rem "\" abschneiden wenn vorhanden
   call :PathCutLastDirDo PathCutLastDir$tempRes %PathCutLastDir$tempNoBacks%
 ) else (
   rem
   call :PathCutLastDirDo PathCutLastDir$tempRes %PathCutLastDir$temp%
 )
 set PathCutLastDir$tempRes=%PathCutLastDir$tempRes:~0,-1%
 set %1=%PathCutLastDir$tempRes%
 set PathCutLastDir$temp=
 set PathCutLastDirDo$temp1=
 set PathCutLastDir$tempNoBacks=
 set PathCutLastDir$tempNoLastChar=
 set PathCutLastDir$tempLastChar=
 set PathCutLastDir$tempRes=
 goto :eof

:PathCutLastDirDo
 rem hiermit schneiden wir den Path ab
 rem echo.
 rem Echo P1=%1 P2=%2
 set PathCutLastDirDo$temp=%~dp2
 rem "\" abschneiden
 set PathCutLastDirDo$temp1=%PathCutLastDir$temp:~0,-1%
 set %1=%PathCutLastDirDo$temp%
 set PathCutLastDirDo$temp=
 set PathCutLastDirDo$temp1=
 goto :eof

rem -----------------------------------------------------------------------
:DateTimeNowGet
 rem call :DateTimeNowGet
 rem Set File_LPNE=%DatRoot_LP%\MyName-%DateTimeNowFileExt%.txt
 if     "%time:~0,1%"==" " set time-h=0%time:~1,1%
 if not "%time:~0,1%"==" " set time-h=%time:~0,2%

 if     "%time:~3,1%"==" " set time-m=0%time:~4,1%
 if not "%time:~3,1%"==" " set time-m=%time:~3,2%

 set Date-Y=%Date:~6,4%
 set Date-M=%Date:~3,2%
 set Date-D=%Date:~0,2%
 set DateTimeNowFileExt=%Date-Y%-%Date-M%-%Date-D%-%time-h%-%time-m%
 goto :eof


:Wait
 set waitTime=2
 if not "%1"=="" set waitTime=%1
 CHOICE /C:w /N /T:w,%waitTime% warte %waitTime% [sec] oder "w" fuer weiter druecken.
 goto :eof


rem -----------------------------------------------------------------------
:Parse_ALL
 rem parst alle File Bezeichner aus
 rem "\" abschneiden
 set Parse_all$temp=%~dp1
 set Parse_all$temp=%Parse_all$temp:~0,-1%
 set %2_DP=%Parse_all$temp%
 set %2_D=%~d1
 rem "\" hinten und vorne abschneiden
 set Parse_all$temp=%~p1
 set Parse_all$temp=%Parse_all$temp:~1,-1%
 set %2_P=%Parse_all$temp%
 set %2_NE=%~nx1
 set %2_N=%~n1
 set %2_E=%~x1
 set %2_DPNE=%1
 set %2_DPN=%~dpn1
 set Parse_all$temp=
goto :eof




