@echo off
REM  cls
:MAIN

 rem ---------------------------------------------------------------------------
 rem JobManager V2 Script fuer den DatenExport mit dem PLMJobManager (c) J.Feuerstein
 rem ---------------------------------------------------------------------------
 rem Dokumentation PLMJobManager Scripts/Param anwendbare Parameter:
 rem set=JTExport=true        		= schaltet den Export von JT Files ein
 rem set=ParasolidExport=true 		= schaltet den Parasolid Export ein
 rem set=DXFExport=true       		= schaltet den DXF Export ein
 rem set=DWGExport=true       		= schaltet den DWG Export ein
 rem set=StepExport=true     	 	= schaltet den Step Export ein
 rem set=StepExport=true    	  	= schaltet den Step Export ein
 rem set=JTTCUpdate=true			= schaltet JTUpdate ein
 rem set=CheckMate=true          	= schaltet CheckMate ein
 rem ---------------------------------------------------------------------------
 rem Aenderungs Info:
 rem                   User   Date/Time (Shift+strg+T)     Infotext:
 set MyApplCurVerInfo=J.Fes   30.11.2007        Ersterstellung
 set MyApplCurVerInfo=J.Fes   18.12.2007        laufende anpassung
 set MyApplCurVerInfo=J.Fes   05.05.2008        JT Export/Update ergaenzt
 set MyApplCurVerInfo=J.Fes   23.11.2008        StepExport ergaenzt
 set MyApplCurVerInfo=K.Sch   17.08.2011        Umstellung der Eingabeparameter
 set MyApplCurVerInfo=K.Sch   20.09.2011        added CheckMate
 rem Echo  ---------------------------------------------------------------

 set JobMgr_TcUser=%1
 set JobMgr_TcPw=%2
 rem -- Basiseinstellungen fuer das Verhalten es Scriptes ----------------------
 REM Hier knnen Verschiedene Einstellungen getroffen werden die steuern wie das Script ablaufen soll
 rem      Die mit "#" Gitter eingeschlossenen Variablen werden vom JobServer ersetzt

 REM Alle wichtigen Stellen sind mit ## gekennzeichnset
 REM ##Doc:  steht an allen Dokumentations Stellen
 REM ##ToDo: steht an allen stellen die angepasst werden sollen

 rem Debug: [bei Einzel Test's auf=ON] [sonst auf OFF stellen]
 set JobMgr_Debug=OFF
 rem -- JobScriptParametersExtended:
 rem    Hinweis:"JobScriptParametersExtended" ist nach dem ausfueller der # variablen leer
 rem             wenn das Datenfeld von Script/Param. J.Cmd.ParmExt auch leer ist
 #JobScriptParametersExtended#

 set JobStartDateTime=%Date%/%time:~0,8%

 rem Farbe setzen am Anfang auf IsIdel
 Call :ColorSet IsIdel

 rem #Variablen ersetzungs Abschnitt
 rem Info die mit "#" Gitter eingeschlossenen Vaiablen werden vom JobServer
 rem vor dem senden an den JobClient ersetzt Beispiel: #JobName#
 set JobName=#JobName#
 set JobParameter=#JobParameter#
 set RefilePaket_NE=#RefilePaket_NE#


 set TceSiteId=#TceSiteId#
 set TceUser=#TceUser#
 set TceUserPassword=#TceUserPassword#

 rem -- JobParameter
 set JobPlaner_Param=#JobPlaner_Param#
 set JobPlaner_Name=#JobPlaner_Name#
 set JobOwner=#JobPlaner_Owner#
 set JobObjectsPacket_NE=#JobObjectsPacket_NE#
 set JobObjectsPacketAllDetails_NE=#JobObjectsPacketAllDetails_NE#

 rem JobManager Pathvariablen uebernehmen
 set BinServer_DP=#01-BinServer_DP#
 set BinClient_DP=#02-BinClient_DP#
 set BinPublic_DP=#03-BinPublic_DP#
 set JobScripts_DP=#10-JobScripts_DP#
 set JobComputerScripts_DP=#20-JobComputerScripts_DP#
 set JobLogArchiv=#10-JobLogArchiv#
 set JM_ApplRoot_DP=#00-ApplRoot_DP#
 set JM_DataRoot_DP=#12-Data#
 set JS_DataRoot_CustomWorkInst_DP=#DataRoot_CustomWorkInst_DP#


 rem Allgemeine Variablen des Scriptes zusammensetzen
 set MyCmd=%0
 set MyApplName_TP=#MyApplName_TP#
 set MyApplMainInfo=%MyApplName_TP% %MyApplCurVerInfo%

 rem entfernt einen bereits laufenden ApiServerProzess
 rem call "%BinPublic_DP%\ApiServerKill.cmd"

 rem ## Netzwerk Laufwerke pruefen und gegebenfalls verbindungen herstellen
 rem if not exist Q:\NXDataExport net use q: /d /y& net use Q: \\jf-18-vmw2000\ugsshare

 rem Prfung Interaktiver oder NonInterAktiver Modus
 if "%JM_ApplRoot_DP:~1,-1%"=="00-ApplRoot_DP" (
   Echo diese Routine darf nur via PLMJobManager ausgefuehrt werden
   Echo Info das Script wird jetzt beendet
   pause
   exit
 )

 call :PathCutLastDir ApplRoot_LP %~dp0

 rem initaliesiert die Umgebung
 set myAppl_Title=NXDataExport(Running Init)
 title %myAppl_Title%

 rem PathExtend
 set CurCmdRoot_DP=%~dp0
 set CurCmdRoot_DP=%CurCmdRoot_DP:~0,-1%
 rem suchpath erweitern
 set Path=%CurCmdRoot_DP%;%BinPublic_DP%;%Path%

 Echo.
 Echo **************************************************************************
 Echo * %MyApplMainInfo%                                         *
 Echo * executing PLMJobManager script for:                                    *
 Echo *  - exporting NX Data to: Step / JT / Parasolid / DWG / DXF /           *
 Echo *  - creating or updating JT Files for TcEng                             *
 Echo **************************************************************************

 rem ---------------------------------------------------------
 rem ## TCEPromtCmd organiesieren
 rem - NX5 Ver einstellen
 rem set NXver=NX5   



REM ##ToDo: SetUp Tc Prompt
 if /i "#TceSiteId#" neq "TC8Pilot" goto :JumbOver1 {
   set TcPromtCmd=\\demas0079\ugsshare\start_apps\windows\start_nx75.bat
   set TcPromtCmdOpt=de tc_prompt tc8 tc83 }

 :JumbOver1
 
if /i "#TceSiteId#" neq "TC8_Test" goto :JumbOver1 {
   set TcPromtCmd=\\demas0908\ugsshare\start_apps\windows\start_nx75.bat
   set TcPromtCmdOpt=de tc_prompt tc8 tc83 }

 :JumbOver1

 if     exist "%TcPromtCmd%" call "%TcPromtCmd%" %TcPromtCmdOpt%
 if not exist "%TcPromtCmd%" goto :TCEPromtCmdError

  if /I "%JobMgr_Debug%" equ "ON" (
   pause
 )


 rem -- Suchpath angepasst erforderlich da sonst die programme nicht starten koennen Achtung erst Prompt durchlaufen!
 set Path=%UGII_BASE_DIR%;%UGII_ROOT_DIR%;%CurCmdRoot_DP%;%BinPublic_DP%;%Path%

 rem ------ Anwenderstandards *.dpv umbiegen --- wichtig muss im  ..\StartUp\.. Verzeichnis liegen
 rem ## Customer Anwenderstandards einfgen !!
 rem Hinweis die verwendeten Anwenderstandarts sind in das Verzeichnis:
 rem ..\10-JobScripts\NXDataProcessIng\ClientScripts\StartUp\%NXver%_NxDataProcessing.dpv
 rem ..\StartUp\.. zu legen !!
REM  set UGII_USER_DIR=%CurCmdRoot_DP%
REM  set UGII_GROUP_DIR=%CurCmdRoot_DP%
REM  set UGII_SITE_DIR=%CurCmdRoot_DP%
REM  SET UGII_LOCAL_USER_DEFAULTS=%CurCmdRoot_DP%\startup\%NXver%_NxDataProcessing.dpv
REM  copy "%UGII_LOCAL_USER_DEFAULTS%"  "%UGII_SITE_DIR%\startup\%NXver%_site.dpv">nul
REM  copy "%UGII_LOCAL_USER_DEFAULTS%"  "%UGII_GROUP_DIR%\startup\%NXver%_group.dpv">nul
REM  copy "%UGII_LOCAL_USER_DEFAULTS%"  "%UGII_USER_DIR%\startup\%NXver%_user.dpv">nul

 set myAppl_Title=NXDataProcessing (%ORACLE_SID%)
 title %myAppl_Title%

 rem !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
 rem Hauptroutine fr den Datenexport via JobManager

 rem ##debug bitte entfernen
 if /i "%JobOwner%"=="Jopp" set JobOwner=JFes
 rem if /i "%JobOwner%"=="Jopp" set JobOwner=ABecker

 rem ## diesen Path evtl. anpassen. Hinweis siehe subpath=..\_ExportControl..
 set ExportRoot_DP=%JM_DataRoot_DP%\_NxExportData
 if not "%JobOwner%"==""       set ExportRoot_DP=%ExportRoot_DP%\%JobOwner%
 if not "%JobPlaner_Name%"=="" set ExportRoot_DP=%ExportRoot_DP%\%JobPlaner_Name%

 rem ---------------------------------------------------------
 rem temp dir Organiesieren
 if "%temp_DP_org%"=="" set temp_DP_org=%temp%
 set temp=%CurCmdRoot_DP%
 if not exist "%temp%" md "%temp%"

 rem -- JobParameter von JobPlaner_Param wenn JobPlaner_Param uebergeben wurden ---------------
 if not "%JobPlaner_Param%"=="" SET JobParameter=%JobPlaner_Param%
 rem workaround 10.5.09 J.Fes
 if "%JobParameter%"=="" SET JobParameter=-DummyParamBecauseNoParaWasSet

 rem -- Parameter parsen -JTExport Ein/Aus ---------------
 rem -- Wird nicht mehr bentigt, da die Variabelen ausgelsen werden! ---
 
 
 
 
 rem Echo %myAppl_Title%
 Echo ------------------------------------------------------------------------
 Echo JobInfo:       : %myAppl_Title%
 Echo ------------------------------------------------------------------------
 Echo JobOwner       : %JobOwner%
 Echo JobName        : %JobName%
 Echo Computer       : %ComputerName%
 Echo TceSide        : %TceSiteId%
 Echo TceUser        : %TceUser%
 Echo.
 Echo JobDir         : %temp%
 Echo JobParameter   : %JobParameter%
 Echo Start time     : %JobStartDateTime%
 Echo.
 Echo Export Parameter:
 Echo StepExport     : %StepExport%
 Echo JT Export      : %JTExport%
 Echo JT TceUpdate   : %JTTCUpdate%
 Echo ParasolidExport: %ParasolidExport%
 Echo DXFExport      : %DXFExport%
 Echo DWGExport      : %DWGExport%
 Echo CheckMate      : %CheckMate%
 Echo ------------------------------------------------------------------------
 Echo.
  if /I "%JobMgr_Debug%" equ "ON" (
   pause
 )

 set JobObjectsPacket_DPNE=%CurCmdRoot_DP%\%JobObjectsPacket_NE%
 set JobObjectsPacketAllDetails_DPNE=%CurCmdRoot_DP%\%JobObjectsPacketAllDetails_NE%

 set JobProcessResultLog_DPNE=%temp%\_%JobName%_JobResultsGenericV1.Log

 rem -- Verzeichnis in dem die ContolListen abgelegt werden
 set ControlList_DP=%temp%\ControlLists
 if not exist "%ControlList_DP%" md "%ControlList_DP%"

 rem -- SP=Einzelteile Export Listen Filenamen
 set ExportListNXMasterSP_DPNE=%ControlList_DP%\_ExportListNXMasterSP.txt
 set ExportControlListNXMasterSp_DPNE=%ControlList_DP%\_ExportControlListNXMasterSp.txt
 set ExportControlListNXMasterSpAllDetails_DPNE=%ControlList_DP%\_ExportControlListNXMasterSp_AllDetails.txt

 rem -- AP=Baugruppen Export Listen Filenamen
 set ExportListNXMasterAP_DPNE=%ControlList_DP%\_ExportListNXMasterAp.txt
 set ExportControlListNXMasterAp_DPNE=%ControlList_DP%\_ExportControlListNXMasterAp.txt
 set ExportControlListNXMasterApAllDetails_DPNE=%ControlList_DP%\_ExportControlListNXMasterAp_AllDetails.txt

 rem -- DXF File Export Liste FileName
 set DxfDwgExportList_DPNE=%ControlList_DP%\_DxfExportList.txt
 set DxfDwgExportListAllDetails_DPNE=%ControlList_DP%\_DxfExportListAllDetails.txt

 rem -- Not to Export Liste Filename
 set NoExportList_DPNE=%ControlList_DP%\_NoExportList.txt

 Echo --------------------------------------------------------------------------
 Echo List of Objects to process in this Job:
 set ObjectsToProcessN=0
 rem start "" Explorer.exe /e, "%temp%"
 FOR /F "skip=1 delims=" %%i in (%JobObjectsPacketAllDetails_DPNE%) do call :ObjectToProcessCound "%%i"

 rem aufteilen der Datasets nach Typen Parasolid und DXF Export Packeten
 set ObjectNr=0
 FOR /F "skip=1 delims=" %%i in (%JobObjectsPacketAllDetails_DPNE%) do call :DataSetsSepToLists "%%i"

 rem goto :TestCheckResult

 rem Export der SP=Singleparts=Einzelteile nach Parasolid
 if /I "%ParasolidExport%"=="true" if exist "%ExportControlListNXMasterSpAllDetails_DPNE%"  call :ParaSolidExport "%ExportControlListNXMasterSpAllDetails_DPNE%" SP
 rem Export der AP=Assemblyparts=Baugruppen nach Parasolid
 if /I "%ParasolidExport%"=="true" if exist "%ExportControlListNXMasterApAllDetails_DPNE%"  call :ParaSolidExport "%ExportControlListNXMasterApAllDetails_DPNE%" AP

 rem Export der SP=Singleparts=Einzelteile nach Step214
 if /I "%StepExport%"=="true" if exist "%ExportControlListNXMasterSpAllDetails_DPNE%" call :Step214UGExport "%ExportControlListNXMasterSpAllDetails_DPNE%" SP
 rem Export der AP=Assembly=Baugruppen nach Step214
 if /I "%StepExport%"=="true" if exist "%ExportControlListNXMasterApAllDetails_DPNE%" call :Step214UGExport "%ExportControlListNXMasterApAllDetails_DPNE%" AP

 rem Export der Dxf Dokumente
 if /I "%DXFExport%"=="true" if exist "%DxfDwgExportListAllDetails_DPNE%" call :ExportDwgDxfPaket "%DxfDwgExportListAllDetails_DPNE%" dxf
 rem Export der Dwg Dokumente
 if /I "%DWGExport%"=="true" if exist "%DxfDwgExportListAllDetails_DPNE%" call :ExportDwgDxfPaket "%DxfDwgExportListAllDetails_DPNE%" dwg

 rem -- JT Native Exporting Singleparts
 IF /i "%JTExport%"=="true" if exist "%ExportListNXMasterSP_DPNE%" call :JTExportSP
 rem -- JT Native Exporting Assemblyparts
 IF /i "%JTExport%"=="true" if exist "%ExportListNXMasterAP_DPNE%" call :JTExportAP

 rem -- JT Update TCE Singleparts
 IF /i "%JTTCUpdate%"=="true" if exist "%ExportListNXMasterSP_DPNE%" call :JTTCUpdateSP
 rem -- JT Native Exporting Assemblyparts
 IF /i "%JTTCUpdate%"=="true" if exist "%ExportListNXMasterAP_DPNE%" call :JTTCUpdateAP

 rem -- Customer script for TC Singleparts
 IF /i "%CheckMate%"=="true" if exist "%ExportListNXMasterSP_DPNE%" call :CheckMateSP
 rem -- Customer script for TC Assemblyparts
 IF /i "%CheckMate%"=="true" if exist "%ExportListNXMasterAP_DPNE%" call :CheckMateAP



 if exist "%NoExportList_DPNE%" Echo List of Dataset not to Export:& Type "%NoExportList_DPNE%"

:TestCheckResult
 Call :CheckResult


  if /I "%JobMgr_Debug%" equ "ON" (
   pause
 )
 rem hier ist das Ende des Ablaufes
 rem alle nicht erforderlichen Dateien aus den TempVerzeichnissn leschen
 del %temp%\*.jnl,%temp%\mapping_file_errors.txt,%temp%\apiserver.exe*,%temp%\*.prt /s /q>nul
 rem am Ende
 set temp=%temp_DP_org%
 cd /d "%temp_DP_org%"
 set JobEndDateTime=%Date%/%time:~0,8%
 Echo Job: %JobName% beendet %JobEndDateTime%

 Echo ---------------------------------------------------
 rem und die farben wieder zurueckstellen
 Call :ColorSet End

 if /I "%JobMgr_Debug%" equ "ON" (
   pause
 )
goto :eof

:CheckResult
 rem Aufgabe:
 rem suche ob es zu jedem Eintrag in %JobObjectsPacketAllDetails_DPNE%
 rem ein Ergebniss %JobProcessResultLog_DPNE% in enthalten ist

 FOR /F "skip=1 delims=" %%i in (%JobObjectsPacketAllDetails_DPNE%) do call :CheckResultDo "%%i"
 call :SendInfoMail
 goto :eof

:CheckResultDo
 setlocal
   rem prueft ob es fr den %ObjectCliName% ein Ergebnis in "%JobProcessResultLog_DPNE%" gefunden werden kann
   rem wenn nicht dann wird -100 alles Ergebniss zureck gegeben

   call :DataSetSplit %1

   set AddToNotProssed=false
   set ResultText=No Export was done for this Object

   Echo such in: "%JobProcessResultLog_DPNE%"
   Echo nach     %ObjectCliName%

   rem if not exist "%JobProcessResultLog_DPNE%" set AddToNotProssed=true& goto :next

   findstr /c:"%ObjectCliName%" "%JobProcessResultLog_DPNE%" >nul 2>nul
   set ObjectCliFound_inJobLog=%errorlevel%
   if not "%ObjectCliFound_inJobLog%"=="0" set AddToNotProssed=true
   rem Echo  ObjectCliFound_inJobLog=%ObjectCliFound_inJobLog%
   rem pause

   :next
   if /i "%AddToNotProssed%"=="true" (
      rem Object zu NotProcessd hinzufgen
      call :JobResultsGenericV1_WriteLog  "%ObjectCliName%" "-100" "%ResultText%" "" %ItemName% %RevName%
   ) ELSE (
      Type "%JobProcessResultLog_DPNE%"
   )
 endlocal
 goto :eof

:SendInfoMail
 setlocal
   set eMailAdress=JFes@PLMJobManager.com
   set MailSubjText=-s "JobMgr:%myAppl_Title% JobID:%JobPlaner_Name%"

   rem set server=-server localhost
   set MailServer=-server JF-18
   set MailBodyText_DPNE=%Temp%\zzMailBodyText.txt
   set MailSendLog=%Temp%\zzMailSendLog.txt

   call :ExportFileDest_DP_gen ExportDest_DP PrtDest_DP
   if not exist "%ExportDest_DP%" md "%ExportDest_DP%"
   set JobEndeDateTime=%Date%/%time:~0,8%
   rem Mail Body zusammensetzen

   Echo Hallo %JobOwner%>>"%MailBodyText_DPNE%"
   Echo.>>"%MailBodyText_DPNE%"
   Echo Info Mail vom PLMJobManager>>"%MailBodyText_DPNE%"
   Echo JobID........: %JobPlaner_Name%>>"%MailBodyText_DPNE%"
   Echo JobType......: NX-Export>>"%MailBodyText_DPNE%"
   Echo JobParameter.: %JobPlaner_Param%>>"%MailBodyText_DPNE%"
   Echo.>>"%MailBodyText_DPNE%"
   Echo JobComputer..: \\%ComputerName%>>"%MailBodyText_DPNE%"
   Echo JobStart.....: %JobStartDateTime%>>"%MailBodyText_DPNE%"
   Echo JobEnde......: %JobEndeDateTime%>>"%MailBodyText_DPNE%"
   Echo.>>"%MailBodyText_DPNE%"
   Echo JobResult....: Files wurden in das folgende Verzeichnis exportiert:>>"%MailBodyText_DPNE%"
   Echo          ....: %ExportDest_DP%>>"%MailBodyText_DPNE%"
   Echo.>>"%MailBodyText_DPNE%"
   Echo Info:>>"%MailBodyText_DPNE%"
   Echo ----->>"%MailBodyText_DPNE%"
   Echo Diese Mail wurde mit dem PLMJobManager automatisch erstellt.>>"%MailBodyText_DPNE%"
   rem Type "%MailBodyText_DPNE%"

   rem set x=-x "X-Header-Test: Can Blat do it? Yes it Can!"
   set debug=-debug -log "%MailSendLog%" -timestamp
   rem ::::::::::::::::: Now we run Blat!  :::::::::::::::::
   rem set toRun=blat "%MailBodyText_DPNE%" -to %eMail% -f %eMail% %subj% %server% %debug% %x%
   set toRun=blat "%MailBodyText_DPNE%" -to %eMailAdress% -f %eMailAdress% %MailSubjText% %MailServer% %debug%
   rem Echo %toRun%
   %toRun% >nul 2>nul

 endlocal
 goto :eof

rem ----------------------------------------------------------------------------
rem !! Step Export !!
rem ----------------------------------------------------------------------------
:Step214UGExport

 setlocal
  rem P1 = ExportControlListIn_DPNE
  set ExportControlListIn_DPNE=%1
  set ExportControlListIn_DPNE=%ExportControlListIn_DPNE:~1,-1%
  rem P2 = ExportType uebernehmen
  set ExpoSpApType=%2

  set CurActionTitle=Step214UGExport[%ExpoSpApType%]
  rem Printausgabe
  Call :PrintCurrAction "%CurActionTitle% start"

  set StepExpo_DP=%temp%\_StepExpo
  if not exist "%StepExpo_DP%" md "%StepExpo_DP%"
  set temp=%StepExpo_DP%

  set toRunInfo_DPNE=%temp%\_Job_%CurActionTitle%_log.txt

  rem Step Dateien exportieren lassen
  FOR /F "delims=" %%i in (%ExportControlListIn_DPNE%) do call :Step214UGExportDoRun "%%i"

  rem Liste der Exportierten Daten mitschreiben
  Dir /N /O:n "%StepExpo_DP%\*.stp">>"%toRunInfo_DPNE%" 2>nul

  rem Exportierte Step Dateien in die Zielverzeichnisse uebertragen Info:hier werden auch die Ergebnisse erstellt
  FOR /F "delims=" %%i in (%ExportControlListIn_DPNE%) do call :StepExport_MovePartToArchiv "%%i"

  rem Printausgabe
  Call :PrintCurrAction "%CurActionTitle% end"

 endlocal
 goto :eof

rem ---------------------------------------------------------------------------------
:Step214UGExportDoRun
   rem erzeut einen StepFile
  setlocal

   Call :DataSetSplit %1

   rem entfernt einen bereits laufenden ApiServerProzess
   call "%BinPublic_DP%\ApiServerKill.cmd"

   rem NX Umgebung einstellen
   call :NxSetEnvironForExport

   rem toRun .. fuer UG to Step zusammensetzen
   set StepDef_DPNE=%CurCmdRoot_DP%\ugstep214.def
   Call :StepExportSetFileNames
   rem Beispiel: "D:\UGS\UGNX4\step214ug\step214ug.cmd" "@DB/000204/A" o="C:\TEMP\000204_A.stp" l="C:\TEMP\000204_000\000204_A.log" d="D:\UGS\UGNX4\STEP214UG\ugstep214.def"
   rem STEP203UG bzw STEP214UG unterscheiden sich bezglich der Exportierten Geometrie 3D und Draht Geometrie
   set toRun=call "%UGII_BASE_DIR%\STEP214UG\step214ug.cmd" "%IrCli%"
   set JobParameter=o="%StepExpoFile_DPNE%"
   set JobParameter=%JobParameter% l="%StepExpoLog_DPNE%"
   set JobParameter=%JobParameter% d="%StepDef_DPNE%"
   set JobParameter=%JobParameter% -pim=yes -u=%TceUser% -p=%TceUserPassword%

   rem command vollstndig zusammensetzen
   set toRun=%toRun% %JobParameter%
   echo %toRun%>>%toRunInfo_DPNE%
   rem echo %0
   %toRun%
  endlocal

 goto :eof

rem ---------------------------------------------------------------------------------
:StepExportSetFileNames
   rem setzt die StepExpoFile Namen zusammen Info: es werden die aktuell gesetzten %ItemName%_%RevName% var's verwendet
   set StepFile_NE=%ItemNameNoBlanks%_%RevNameNoBlanks%.stp
   set StepExpoFile_DPNE=%StepExpo_DP%\%StepFile_NE%
   set StepExpoLog_DPNE=%StepExpo_DP%\%ItemNameNoBlanks%_%RevNameNoBlanks%_stp_gen.log
 goto :eof


:StepExport_MovePartToArchiv

  rem schiebt die exportierte Step Datei in das Zielverzeichnis
  setlocal

   call :DataSetSplit %1
   call :StepExportSetFileNames

   if     exist "%StepExpoFile_DPNE%" goto :StepFile_MoveToArchiv
   if not exist "%StepExpoFile_DPNE%" goto :StepFileExportRun_StepFileExpoErr

   :StepFile_MoveToArchiv

    rem Zielverzeichnis des StepFile Files
    call :ExportFileDest_DP_gen StepFile_Dest_DP PrtDest_DP
    
    rem ## Zieldateiname des StepFile Files evtl mit %ExpoSpApType%
    rem set StepFile_Dest_NE=%ItemNameNoBlanks%_%RevNameNoBlanks%_%ExpoSpApType%.stp
    set StepFile_Dest_NE=%ItemNameNoBlanks%_%RevNameNoBlanks%.stp
    set StepFile_Dest_DPNE=%StepFile_Dest_DP%\%StepFile_Dest_NE%

    rem Zielverzeichnis erzeugen
    if not exist "%StepFile_Dest_DP%" md "%StepFile_Dest_DP%">>"%toRunInfo_DPNE%"
    set StepFileExpoErrLevel=%errorlevel%
    if not exist "%StepFile_Dest_DP%" goto :StepFileExportRun_CreatePathErr

    rem StepFile Datei in das Verzeichnis verschieben
    Echo moving: Exported StepFile File [%ItemName%/%RevName%]
    Echo from: %StepExpoFile_DPNE%
    Echo   to: %StepFile_Dest_DPNE%

    move /Y "%StepExpoFile_DPNE%" "%StepFile_Dest_DPNE%">>"%toRunInfo_DPNE%"
    set StepFileExpoErrLevel=%errorlevel%

    if not "%StepFileExpoErrLevel%"=="0" goto :StepFile_MoveToArchivErr
    if     exist "%StepFile_Dest_DPNE%"  goto :StepFile_MoveToArchivOK
    if not exist "%StepFile_Dest_DPNE%"  goto :StepFile_MoveToArchivErr

    :StepFile_MoveToArchivOK
     rem --- schreiben der Ergebnisse in den Ergebnisfile
     Set ResultText=Step-Expo:OK %StepFile_Dest_DPNE%
     Echo %ResultText%>>"%toRunInfo_DPNE%"
     call :JobResultsGenericV1_WriteLog  "%ObjectCliName%" "0" "%ResultText%" "" %ItemName% %RevName%
     goto :StepFile_MoveToArchivEnde

    :StepFileExportRun_StepFileExpoErr
     rem --- schreiben der Ergebnisse in den Ergebnisfile
     Set ResultText=Step-Expo:Err StepFile file:[%StepFile_NE%] cound not be exported
     Echo %ResultText%>>"%toRunInfo_DPNE%"
     call :JobResultsGenericV1_WriteLog  "%ObjectCliName%" "100" "%ResultText%" "" %ItemName% %RevName%
     goto :StepFile_MoveToArchivEnde

    :StepFileExportRun_CreatePathErr
     rem --- schreiben der Ergebnisse in den Ergebnisfile
     Set ResultText=Step-Expo:Err [OS:%StepFileExpoErrLevel%] user %userName% creating path [%StepFile_Dest_DP%]
     Echo %ResultText%>>"%toRunInfo_DPNE%"
     call :JobResultsGenericV1_WriteLog  "%ObjectCliName%" "110" "%ResultText%" "" %ItemName% %RevName%
     goto :StepFile_MoveToArchivEnde

    :StepFile_MoveToArchivErr
     rem --- schreiben der Ergebnisse in den Ergebnisfile
     Set ResultText=Step-Expo:Err [OS:%StepFileExpoErrLevel%] moving part to:[%StepFile_Dest_DPNE%]
     Echo %ResultText%>>"%toRunInfo_DPNE%"
     call :JobResultsGenericV1_WriteLog  "%ObjectCliName%" "120" "%ResultText%" "" %ItemName% %RevName%
     goto :StepFile_MoveToArchivEnde

   :StepFile_MoveToArchivEnde

  endlocal
 goto :eof

rem ----------------------------------------------------------------------------
rem !! JT Export/Update TCE !!
rem ----------------------------------------------------------------------------
:JTTCUpdateSp
   set CurActionTitle=JTTCUpdate[SP]

   rem Printausgabe
   Call :PrintCurrAction "%CurActionTitle% start"
   type "%ExportListNXMasterSP_DPNE%"

   call :JTgenSetEnviron

   set toRunInfo_DPNE=%temp%\_Job_%CurActionTitle%_log.txt

   rem - ugtopv.exe .. toRun for TCE NX zusammenstellen
   set tessConfig_DPNE=%CurCmdRoot_DP%\%tess_file%

   set toRun="%UGII_BASE_DIR%\PVTRANS\ugtopv.exe" -pim=yes -u=%TceUser% -p=%TceUserPassword%
   set JobParameter="%ExportListNXMasterSP_DPNE%"
   set JobParameter=%JobParameter% -noupdate
   set JobParameter=%JobParameter% -config="%tessConfig_DPNE%"
   set JobParameter=%JobParameter% -single_part

   rem command vollstndig zusammensetzen
   set toRun=%toRun% %JobParameter%

   echo %toRun%>>%toRunInfo_DPNE%
   rem for /d %%i in (%toRun%) do Echo ToRun: %%i

   rem -- start JT GEN --
   %toRun%

   rem -- Auswerten der Logfiles --> check Results
   FOR /F "tokens=1,2,3,4 delims=;" %%i in (%ExportControlListNXMasterSp_DPNE%) do call :JTTCUpdateReportresults "%%i" "%%j" "%%k" "%%l" "SP"

   rem Printausgabe
   Call :PrintCurrAction "%CurActionTitle% end"
 goto :eof

rem ---------------------------------------------------------------------------------
:JTTCUpdateReportResults
   rem erstellt die Ergebnissdatei
   setlocal

     set ItemName=%1
     set RevName=%2
     set ObjectCliName=%3
     set ExpoType=%5

     rem strip '"'
     set ItemName=%ItemName:"=%
     set RevName=%RevName:"=%
     set ObjectCliName=%ObjectCliName:"=%

     set ExpoType=%ExpoType:"=%

     set JTgenLog_DPNE=%temp%\%ItemName%_%RevName%_LOG
     rem allgemeiner Dateiname des JT
     if     exist "%JTgenLog_DPNE%" goto :JTTCUpdate_CheckResult
     if not exist "%JTgenLog_DPNE%" goto :JTTCUpdate_CreateJTErr

     :JTTCUpdate_CheckResult

     rem Auswerten der Ergebnisse aus den Logfiles
     rem Achtung Reihenfolge:
     rem -- hier folgen die Auswertungen die einen Fehler reporten  WARNING 2150 :Did not need to generate jt data for
     findstr /c:"WARNING 2150" "%JTgenLog_DPNE%">>"%toRunInfo_DPNE%"
     set JTExpoErrLevel=%errorlevel%
     if "%JTExpoErrLevel%"=="0" goto :JTTCUpdate_CreateJTErr

     rem -- hier folgen die Auswertungen die ein OK reporten  INFO 4310 :TCEng Info:imported into TCEng item
     findstr /c:"INFO 4310" "%JTgenLog_DPNE%">>"%toRunInfo_DPNE%"
     set JTExpoErrLevel=%errorlevel%
     if  "%JTExpoErrLevel%"=="0" goto :JTTCUpdate_CreateJTOK

     rem -- NFO 3165 :Successfully generated jt data for part
     findstr /c:"INFO 3165" "%JTgenLog_DPNE%">>"%toRunInfo_DPNE%"
     set JTExpoErrLevel=%errorlevel%
     if  "%JTExpoErrLevel%"=="0" goto :JTTCUpdate_CreateJTOK

     rem -- wenn jetzt Fehler vorhanden da kein OK gefunden wurde zur Error auswertung gehen
     if not "%JTExpoErrLevel%"=="0" goto :JTTCUpdate_CreateJTErr

      :JTTCUpdate_CreateJTOk
       rem --- schreiben der Ergebnisse in den Ergebnisfile
       call :JobResultsGenericV1_WriteLog  "%ObjectCliName%" "0" "JT-TcUpdate:OK" "" %ItemName% %RevName%
       goto :MyEnde

      :JTTCUpdate_CreateJTErr
       rem --- schreiben der Ergebnisse in den Ergebnisfile
       call :JobResultsGenericV1_WriteLog  "%ObjectCliName%" "100" "JT-TcUpdate:Err JT file cound not be Updatet in TCE" ""
       goto :MyEnde

      :MyEnde
   endlocal
 goto :eof

rem ---------------------------------------------------------------------------------
:JTTCUpdateAP
   set CurActionTitle=JTTCUpdate[AP]
   rem Printausgabe
   Call :PrintCurrAction "%CurActionTitle% start"
   type "%ExportListNXMasterAP_DPNE%"
   call :JTgenSetEnviron

   set toRunInfo_DPNE=%temp%\_Job_%CurActionTitle%_log.txt

   rem start " " explorer.exe /e, "%temp%"
   rem die Assembly Einzeln erstellen lassen da -honour_structure nur geht wenn der CLIName bergeben wird!
   FOR /F %%i in (%ExportListNXMasterAP_DPNE%) do call :JTTCUpdateAPRun "%%i"

   rem -- Auswerten der Logfiles --> check Results
   FOR /F "tokens=1,2,3,4 delims=;" %%i in (%ExportControlListNXMasterAp_DPNE%) do call :JTTCUpdateReportresults "%%i" "%%j" "%%k" "%%l" "AP"

   rem Printausgabe
   Call :PrintCurrAction "%CurActionTitle% end"
 goto :eof
rem ---------------------------------------------------------------------------------
:JTTCUpdateAPRun
  setlocal
    set CliName=%1
    rem - ugtopv.exe .. toRun for TCE NX zusammenstellen
    set tessConfig_DPNE=%CurCmdRoot_DP%\%tess_file%

    set toRun="%UGII_BASE_DIR%\PVTRANS\ugtopv.exe" -pim=yes -u=%TceUser% -p=%TceUserPassword%

    set JobParameter=%CliName%
    set JobParameter=%JobParameter% -noupdate
    set JobParameter=%JobParameter% -config="%tessConfig_DPNE%"
    set JobParameter=%JobParameter% -honour_structure
    rem command vollstndig zusammensetzen
    set toRun=%toRun% %JobParameter%

    echo %toRun%>>%toRunInfo_DPNE%
    rem for /d %%i in (%toRun%) do Echo ToRun: %%i
    rem -- start JT GEN --
    %toRun%
  endlocal
 goto :eof

rem ---------------------------------------------------------------------------------
:JTExportAP
   set CurActionTitle=JTExport[AP]
   rem Printausgabe
   Call :PrintCurrAction "%CurActionTitle% start"
   call :JTgenSetEnviron
   type "%ExportListNXMasterAP_DPNE%"

   set toRunInfo_DPNE=%temp%\_Job_%CurActionTitle%_log.txt
   rem die Assembly Einzeln erstellen lassen da -honour_structure nur geht wenn der CLIName bergeben wird!
   FOR /F %%i in (%ExportListNXMasterAP_DPNE%) do call :JTExportAPRun "%%i"

   rem Liste der Exportierten Daten mitschreiben
   Dir /N /O:n "%JTFile_LP%\*.jt">>"%toRunInfo_DPNE%"

   rem Exportierete JT Dateien in die Zielverzeichnisse uebertragen hier werden auch die Ergebnisse erstellt
   FOR /F "tokens=1,2,3,4 delims=;" %%i in (%ExportControlListNXMasterAp_DPNE%) do call :JTExportRun_MovePartToArchiv "%%i" "%%j" "%%k" "%%l" "AP"

   rem Printausgabe
   Call :PrintCurrAction "%CurActionTitle% end"
 goto :eof

rem ---------------------------------------------------------------------------------
:JTExportAPRun
  setlocal
    set CliName=%1
    rem - ugtopv.exe .. toRun for TCE NX zusammenstellen
    set tessConfig_DPNE=%CurCmdRoot_DP%\%tess_file%

    set toRun="%UGII_BASE_DIR%\PVTRANS\ugtopv.exe" -pim=yes -u=%TceUser% -p=%TceUserPassword%

    set JobParameter=%CliName%
    set JobParameter=%JobParameter% -noupdate
    set JobParameter=%JobParameter% -config="%tessConfig_DPNE%"
    set JobParameter=%JobParameter% -save_outside_iman -force_output_dir="%JTFile_LP%"
    set JobParameter=%JobParameter% -honour_structure

    rem command vollstndig zusammensetzen
    set toRun=%toRun% %JobParameter%

    echo %toRun%>>%toRunInfo_DPNE%
    rem for /d %%i in (%toRun%) do Echo ToRun: %%i
    rem -- start JT GEN --
    %toRun%
  endlocal
 goto :eof

rem ---------------------------------------------------------------------------------
:JTExportSp
   set CurActionTitle=JTExport[Sp]
   rem Printausgabe
   Call :PrintCurrAction "%CurActionTitle% start"
   call :JTgenSetEnviron
   type "%ExportListNXMasterSP_DPNE%"

   set toRunInfo_DPNE=%temp%\_Job_%CurActionTitle%_log.txt

   rem - ugtopv.exe .. toRun for TCE NX zusammenstellen
   set tessConfig_DPNE=%CurCmdRoot_DP%\%tess_file%

   set toRun="%UGII_BASE_DIR%\PVTRANS\ugtopv.exe" -pim=yes -u=%TceUser% -p=%TceUserPassword%
   set JobParameter="%ExportListNXMasterSP_DPNE%"
   set JobParameter=%JobParameter% -noupdate
   set JobParameter=%JobParameter% -config="%tessConfig_DPNE%"
   set JobParameter=%JobParameter% -save_outside_iman -force_output_dir="%JTFile_LP%"
   rem set JobParameter=%JobParameter% -honour_structure
   set JobParameter=%JobParameter% -single_part
   rem set JobParameter=%JobParameter% -generate_assy_jt
   rem set JobParameter=%JobParameter% -generate_bookmark=%JTFile_LP%\__AssemblyBookMark.bkm
   rem set JobParameter=%JobParameter% -nopopulate

   rem command vollstndig zusammensetzen
   set toRun=%toRun% %JobParameter%

   echo %toRun%>>%toRunInfo_DPNE%
   rem for /d %%i in (%toRun%) do Echo ToRun: %%i

   rem -- start JT GEN --
   %toRun%

   rem Liste der Exportierten Daten mitschreiben
   Dir /N /O:n "%JTFile_LP%\*.jt">>"%toRunInfo_DPNE%" 2>nul

   rem Exportierete JT Dateien in die Zielverzeichnisse uebertragen hier werden auch die Ergebnisse erstellt
   FOR /F "tokens=1,2,3,4 delims=;" %%i in (%ExportControlListNXMasterSp_DPNE%) do call :JTExportRun_MovePartToArchiv "%%i" "%%j" "%%k" "%%l" "SP"

   rem Printausgabe
   Call :PrintCurrAction "%CurActionTitle% end"
 goto :eof


rem ---------------------------------------------------------------------------------
:JTExportRun_MovePartToArchiv
 rem schiebt die exportierte Parasolid Datei in das Zielverzeichnis
 setlocal

   set ItemName=%1
   set RevName=%2
   set ObjectCliName=%3
   set ExpoType=%5

   rem strip '"'
   set ItemName=%ItemName:"=%
   set RevName=%RevName:"=%
   set ObjectCliName=%ObjectCliName:"=%
   set ExpoType=%ExpoType:"=%

   call :ReplaceInvalidChar ItemName_l "%ItemName%"
   call :ReplaceInvalidChar RevName_l "%RevName%"

   rem allgemeiner Dateiname des JT
   set JTFileSearch1_NE=%ItemName%__%RevName%
   set JTFileSearch2_NE=%ItemName%_%RevName%

   rem ersetzungen durchfhren lassen
   call :ReplaceInvalidChar JTFileSearch1_NE "%JTFileSearch1_NE%"
                        set JTFileSearch1_NE=%JTFileSearch1_NE%*.jt
   call :ReplaceInvalidChar JTFileSearch2_NE "%JTFileSearch2_NE%"
                        set JTFileSearch2_NE=%JTFileSearch2_NE%*.jt


   rem Verzeichnis und Dateinamen zusammensetzen
   set JTFileSearch1_DPNE=%JTFile_LP%\%JTFileSearch1_NE%
   set JTFileSearch2_DPNE=%JTFile_LP%\%JTFileSearch2_NE%

   rem Suchen nach dem richtigen JTgenLog_DPNE
   set JTgenLog_DPNE=
   if exist "%temp%\%ItemName%_%RevName%_LOG"     set JTgenLog_DPNE=%temp%\%ItemName%_%RevName%_LOG
   if exist "%temp%\%ItemName_l%_%RevName_l%_LOG" set JTgenLog_DPNE=%temp%\%ItemName_l%_%RevName_l%_LOG

   rem Suchen nach dem richtigen JTFileSearch_NE
   if exist "%JTFileSearch1_DPNE%" set JTFileSearch_NE=%JTFileSearch1_NE%& goto :JTExportRun_MovePartToArchivExecute
   if exist "%JTFileSearch2_DPNE%" set JTFileSearch_NE=%JTFileSearch2_NE%& goto :JTExportRun_MovePartToArchivExecute
   goto :JTExportRun_CreateJTErr

   :JTExportRun_MovePartToArchivExecute
    rem Zielverzeichnis des JT Files
    call :ExportFileDest_DP_gen JT_Dest_DP PrtDest_DP

    rem Zielverzeichnis erzeugen
    if not exist "%JT_Dest_DP%" md "%JT_Dest_DP%"
    set JTExpoErrLevel=%errorlevel%
    if not exist "%JT_Dest_DP%" goto :JTExportRun_CreatePathErr

    rem JT Datei in das Verzeichnis verschieben
    set JTExpoErrLevel=-1
    Set FileList=
    for /R %%i in (%JTFileSearch_NE%) Do call :MoveToArchiv %%i %%~nxi
    if not "%JTExpoErrLevel%"=="0" goto :JTExportRun_MovePartToArchivErr

    :JTExportRun_MovePartToArchivOK
     rem --- schreiben der Ergebnisse in den Ergebnisfile
     call :JobResultsGenericV1_WriteLog  "%ObjectCliName%" "0" "JT-Expo:OK %JT_Dest_DP%\%FileList%" "" %ItemName% %RevName%
     goto :JTExportRun_MoveJTToArchivEnde

   :JTExportRun_CreateJTErr
     if "%JTgenLog_DPNE%"=="" goto :JTExportRun_CreateJTErr_next1
     rem -- hier folgen die Auswertungen die einen Fehler reporten
     findstr /c:"WARNING 2150" "%JTgenLog_DPNE%"
     set JTExpoErrLevel=%errorlevel%
     if "%JTExpoErrLevel%"=="0" call :JobResultsGenericV1_WriteLog "%ObjectCliName%" "0" "JT-Expo:WARNING 2150 :Did not need to generate jt data" ""& goto :JTExportRun_MoveJTToArchivEnde

     findstr /c:"WARNING 2015" "%JTgenLog_DPNE%"
     set JTExpoErrLevel=%errorlevel%
     if "%JTExpoErrLevel%"=="0" call :JobResultsGenericV1_WriteLog "%ObjectCliName%" "0" "JT-Expo:WARNING 2015 :Did not need to generate jt data" ""& goto :JTExportRun_MoveJTToArchivEnde


     :JTExportRun_CreateJTErr_next1
      rem --- schreiben der Ergebnisse in den Ergebnisfile
      call :JobResultsGenericV1_WriteLog  "%ObjectCliName%" "100" "JT-Expo:Err JT file cound not be exported" ""
      goto :JTExportRun_MoveJTToArchivEnde

    :JTExportRun_CreatePathErr
     rem --- schreiben der Ergebnisse in den Ergebnisfile
     call :JobResultsGenericV1_WriteLog  "%ObjectCliName%" "110" "JT-Expo:Err [OS:%JTExpoErrLevel%] user %userName% creating path [%JT_Dest_DP%]" ""
     goto :JTExportRun_MoveJTToArchivEnde

    :JTExportRun_MovePartToArchivErr
     rem --- schreiben der Ergebnisse in den Ergebnisfile
     call :JobResultsGenericV1_WriteLog  "%ObjectCliName%" "120" "JT-Expo:Err [OS:%JTExpoErrLevel%] moving part to:[%JT_Dest_DP%]" ""
     goto :JTExportRun_MoveJTToArchivEnde

    :MoveToArchiv
     if not "%FileList%"=="" set FileList=%FileList%;%1
     if     "%FileList%"=="" set FileList=%2
     Echo -----------------------------------------------------------------
     Echo moving: Exported JT File [%ItemName%/%RevName%]
     Echo from:%1
     Echo   to:%JT_Dest_DP%\%2
     Echo -----------------------------------------------------------------
     move /Y "%1" "%JT_Dest_DP%\%2" >nul 2>nul
     set JTExpoErrLevel=%errorlevel%
     goto :Eof

    :JTExportRun_MoveJTToArchivEnde
 endlocal
 goto :eof

rem ---------------------------------------------------------------------------------
:JTgenSetEnviron
   rem -- setz fuer alle JTgen Vorgaenge die Umgebung ein
   rem Default Files festlegen
   set UGII_LOAD_OPTIONS=%CurCmdRoot_DP%\load_options_DataExport.def
   Echo Tess_file      : %tess_file%
   if not defined tess_file set tess_file=tessUG.Config
   Echo Tess_file      : %tess_file%
   
  
  
   set temp=%temp%\JTgen
   rem set temp=%temp_DP_org%\JTexpoTmp
   if not exist "%temp%" md "%temp%"
   cd /D "%temp%"
  
   set JTFile_LP=%temp%\JTs
   rem if exist "C:\temp" set JTFile_LP=C:\temp\JTexpoTmp
   if not exist "%JTFile_LP%" md "%JTFile_LP%"
   cd /D "%JTFile_LP%"
  
   rem NX Umgebung einstellen
   call :NxSetEnvironForExport
  
    rem ## erweiterte Umgebungsvariablen setzen
   rem This must be set to use the instance ID for CADIDs
   set EAI_XLATR_ENABLE_PERSISTED_INSTANCE_ID=1
   set EAI_USE_MASTER_NOTATION_PMI_FORMAT=1

   rem This must be set to use the instance ID for CADIDs
   set JTK_XLATR_ENABLE_PERSISTED_INSTANCE_ID=1
   set JTK_USE_MASTER_NOTATION_PMI_FORMAT=1

   set UGII_PV_TRANS_MODEL_ANN=1
 goto :eof


 
 
 
 
 
rem ----------------------------------------------------------------------------
rem !! CheckMate for SP!!
rem ----------------------------------------------------------------------------
:CheckMateSp
   set CurActionTitle=CheckMate[SP]

   rem Printausgabe
   Call :PrintCurrAction "%CurActionTitle% start"
   type "%ExportListNXMasterSP_DPNE%"
   
   
   call :CheckMakeSetEnviron

   set toRunInfo_DPNE=%temp%\_Job_%CurActionTitle%_log.txt

   rem - Customer Script 
   
   rem CheckMate
   set toRun="%UGII_BASE_DIR%\DESIGN_TOOLS\checkmate\ug_check_part" -pim=yes -u=%TceUser% -p=%TceUserPassword%
   set JobParameter=-checker "CRI_ASSY_TEST_001"
   set JobParameter=%JobParameter% -output_file "%temp%\check.log"
   set JobParameter=%JobParameter% -log_dir "%temp%"
   set JobParameter=%JobParameter% -option_file "%ExportListNXMasterSP_DPNE%"

   
   rem complete the programm with jobparamter
   set toRun=%toRun% %JobParameter%

   echo %toRun%>>%toRunInfo_DPNE%
   
   
   rem for /d %%i in (%toRun%) do Echo ToRun: %%i

   rem -- start Customer GEN --
   %toRun%
   echo %ExportControlListNXMasterSp_DPNE%
   
   rem -- check Results
   FOR /F "tokens=1,2,3,4 delims=;" %%i in (%ExportControlListNXMasterSp_DPNE%) do call :CheckMateresults "%%i" "%%j" "%%k" "%%l" "SP"
   rem Printausgabe
   Call :PrintCurrAction "%CurActionTitle% end"
 goto :eof

 
rem ----------------------------------------------------------------------------
rem !! CheckMate for AP!!
rem ----------------------------------------------------------------------------
:CheckMateAp
   set CurActionTitle=CheckMate[Ap]

   rem print title
   Call :PrintCurrAction "%CurActionTitle% start"
   type "%ExportListNXMasterAP_DPNE%"
   
   
   call :CheckMakeSetEnviron

   set toRunInfo_DPNE=%temp%\_Job_%CurActionTitle%_log.txt

   rem - Customer Script 
   
   rem CheckMate
   set toRun="%UGII_BASE_DIR%\DESIGN_TOOLS\checkmate\ug_check_part" -pim=yes -u=%TceUser% -p=%TceUserPassword%
   set JobParameter=-checker "CRI_ASSY_TEST_001"
   set JobParameter=%JobParameter% -output_file "%temp%\check.log"
   set JobParameter=%JobParameter% -log_dir "%temp%"
   set JobParameter=%JobParameter% -option_file "%ExportListNXMasterAP_DPNE%"

   
  rem complete the programm with jobparamter
   set toRun=%toRun% %JobParameter%

   echo %toRun%>>%toRunInfo_DPNE%
   
   
   rem for /d %%i in (%toRun%) do Echo ToRun: %%i

   rem -- start Customer GEN --
   %toRun%

   rem -- check Results
   FOR /F "tokens=1,2,3,4 delims=;" %%i in (%ExportControlListNXMasterAP_DPNE%) do call :CheckMateresults "%%i" "%%j" "%%k" "%%l" "AP"

   rem print title
   Call :PrintCurrAction "%CurActionTitle% end"
 goto :eof 
 
 
 
 
rem ---------------------------------------------------------------------------------
:CheckMateresults
   rem erstellt die Ergebnissdatei
   setlocal

     set ItemName=%1
     set RevName=%2
     set ObjectCliName=%3
     set ExpoType=%5

     rem strip '"'
     set ItemName=%ItemName:"=%
     set RevName=%RevName:"=%
     set ObjectCliName=%ObjectCliName:"=%

     set ExpoType=%ExpoType:"=%
	
	 rem rename log_file and set log_file
	 
	 rename %temp%\%ItemName%_%RevName%* %ItemName%_%RevName%.xml
	
	 
	 set CHgenLog_DPNE=%temp%\%ItemName%_%RevName%.xml
   
	 

     rem check is the logfile exist
     if     exist "%CHgenLog_DPNE%" goto :CheckMate_CheckResult
     if not exist "%CHgenLog_DPNE%" goto :CheckMate_LogErr

     :CheckMate_CheckResult

	 
	 
	 
	 rem Auswerten der Ergebnisse aus den Logfiles
     rem Achtung Reihenfolge:
     rem -- hier folgen die Auswertungen die einen Fehler reporten  
     findstr /c:"fail" "%CHgenLog_DPNE%">>"%toRunInfo_DPNE%"
     set CHExpoErrLevel=%errorlevel%
     if "%CHExpoErrLevel%"=="0" goto :CheckMate_CreateCHErr

     
	 rem -- hier folgen die Auswertungen die einen Fehler reporten  
     findstr /c:"pass" "%CHgenLog_DPNE%">>"%toRunInfo_DPNE%"
     set CHExpoErrLevel=%errorlevel%
     if  "%CHExpoErrLevel%"=="0" goto :CheckMate_CreateCHOk
	 
	      

     rem -- wenn jetzt Fehler vorhanden da kein OK gefunden wurde zur Error auswertung gehen
     if not "%CHExpoErrLevel%"=="0" goto :CheckMate_CreateCHErr

      :CheckMate_CreateCHOk
       rem --- schreiben der Ergebnisse in den Ergebnisfile
       call :JobResultsGenericV1_WriteLog  "%ObjectCliName%" "0" "CheckMate:OK" "" %ItemName% %RevName%
       goto :MyEnde

      :CheckMate_CreateCHErr
       rem --- schreiben der Ergebnisse in den Ergebnisfile
       call :JobResultsGenericV1_WriteLog  "%ObjectCliName%" "100" "CheckMate:Err" "" %ItemName% %RevName%
       goto :MyEnde
	   
	   
	   :CheckMate_LogErr
       rem --- schreiben der Ergebnisse in den Ergebnisfile
       call :JobResultsGenericV1_WriteLog  "%ObjectCliName%" "1000" "CheckMate:Err LOGFILE" "" %ItemName% %RevName%
       goto :MyEnde

      :MyEnde
   endlocal
 goto :eof

 
 
rem ---------------------------------------------------------------------------------
:CheckMakeSetEnviron
   rem -- setz fuer alle CheckMate  Vorgaenge die Umgebung ein
   rem Default Files festlegen
   set UGII_LOAD_OPTIONS=%CurCmdRoot_DP%\load_options_DataExport.def
  
   set temp=%temp%\CheckMate

   if not exist "%temp%" md "%temp%"
   cd /D "%temp%"
  
   set CMFile_LP=%temp%\CMFiles
   if not exist "%CMFile_LP%" md "%CMFile_LP%"
   cd /D "%CMFile_LP%"
   
  
   rem NX Umgebung einstellen
   call :NxSetEnvironForExport

 goto :eof


rem ---------------------------------------------------------------------------------
rem !! DXF Export !!
rem ---------------------------------------------------------------------------------
:ExportDwgDxfPaket

   setlocal

     set ExportControlListIn_DPNE=%1
     set ExportControlListIn_DPNE=%ExportControlListIn_DPNE:"=%
     set ExpoDxfDwg_E=%2

     rem temp Dir Organiesieren
     set temp_org=%temp%
     set temp=%temp%\_Expo%ExpoDxfDwg_E%
     if not exist "%temp%" md "%temp%"
     cd /d "%temp%"

     Call :PrintCurrAction "%ExpoDxfDwg_E% Expo start"

     Echo --------------------------------------------
     Echo List of datasets to export all drawing sheeds from NX to %ExpoDxfDwg_E% File:
     FOR /F "delims=" %%i in (%ExportControlListIn_DPNE%) do Call :DataSetSplit "%%i"& Echo "%ObjectCliName%"
     Echo.
     Echo.

     rem NX Umgebung einstellen
     call :NxSetEnvironForExport

     rem Default Files festlegen
     set UGII_LOAD_OPTIONS=%CurCmdRoot_DP%\load_options_DataExport.def
     rem die hier unten stehenden Optionen kann mit extrahierten verwendet werden
     rem set UGII_LOAD_OPTIONS=%CurCmdRoot_DP%\load_options_DataExport_load_no_components.def
     rem Echo Jopp !diese stelle wieder ausbauen !!
     rem Echo UGII_LOAD_OPTIONS=%UGII_LOAD_OPTIONS%
     rem pause

     rem ## nur bis NX2 UGMGR_StructureUpdateOnLoad .. onSave = off
     rem set UGII_DEFAULTS_FILE=%CurCmdRoot_DP%\ug_metric_UGMGR_StructureUpdateOnLoadOnSafe_OFF.def

     rem Liste der Exportierten Daten mitschreiben
     set DxfDwg_output_DP=%temp%

     rem -- Exportiert aller Blaetter aus der Spec _ALL_
     set DxfExport_Ugto2d_Def_DPNE=%temp%\_%JobName%_Ugto2d.def

     rem export "deffile" erstellen
     Call :ExportUgto2d_CreateExpoDefFile
     rem alle bltter der specs als 2D.prt exportieren
     call :ExportUgto2d_doRun_viaDefFile

     rem ## evtl alle DUMMY Bltter lschen !!
     rem del "%DxfDwg_output_DP%\*_*dummy*_2D*.prt"
     rem Konvertiert Item_Rev_Blatt*_2D.prt-in DXF und schiebt diese in das Archiv und Erstellt die Logfile ausgabe
     FOR /F "delims=" %%i in (%ExportControlListIn_DPNE%) do call :DxfDwgExportRun_and_MoveToArchiv "%%i"

     Call :PrintCurrAction "%ExpoDxfDwg_E% Expo end"

   endlocal
 goto :eof

rem ---------------------------------------------------------------------------------
:DxfDwgExportRun_and_MoveToArchiv

  rem Step: Item_Rev_Blatt*_2D.prt nach DWG bzw DXF Konvertiert und das Ergebniss in das Export Archiv schieben
  Call :DataSetSplit %1

  Echo %ExpoDxfDwg_E% konvert: [%ObjectCliName%]

  rem wechseln in das Verzeichnis
  cd /d "%DxfDwg_output_DP%"
  rem alle .prt in DXF bzw DWG umwandeln WICHTIG: ..*.prt
  For %%i IN ("%ItemNameNoBlanks%_%RevNameNoBlanks%*.prt") DO Call :Prt2D_ConvertTo_DxfDwg "%%~dpni"

  cd /d "%DxfDwg_output_DP%"
  rem Dxf Dwg Datei in das Archiv schieben WICHTIG: ..*.prt
  For %%i IN ("%ItemNameNoBlanks%_%RevNameNoBlanks%*.prt") DO Call :DxfDwgMoveToArchiv "%%~dpni"
 goto :eof




rem ---------------------------------------------------------------------------------
:DxfDwgMoveToArchiv

 rem schiebt die exportierte Parasolid Datei in das Zielverzeichnis
 setlocal

  call :ColorSet IsExecuting

  set PrtSource_DPNE=%1.prt
  set DxfDwgSource_DPNE=%1.%ExpoDxfDwg_E%
  set DxfDwgExportLog_DPNE=%1_prt_to_%ExpoDxfDwg_E%.log

  rem strip '"'
  set PrtSource_DPNE=%PrtSource_DPNE:"=%
  set DxfDwgSource_DPNE=%DxfDwgSource_DPNE:"=%
  set DxfDwgExportLog_DPNE=%DxfDwgExportLog_DPNE:"=%

  rem Parsen und zusammensetzen der Dest Dateinamen
  call :Parse_ALL %DxfDwgSource_DPNE% DxfDest
  call :Parse_ALL %PrtSource_DPNE%    PrtDest

  rem Zielverzeichnis im Archiv des Dxf Dwg Files ermitteln
  call :ExportFileDest_DP_gen DxfDwgDest_DP PrtDest_DP

  set DxfDwgDest_DPNE=%DxfDwgDest_DP%\%DxfDest_NE%
  set PrtDest_DPNE=%PrtDest_DP%\%PrtDest_NE%

REM   Echo Debug :DxfDwg_MoveToArchiv
REM   Echo DxfDwgSource_DPNE: %DxfDwgSource_DPNE%
REM   Echo PrtSource_DPNE   : %PrtSource_DPNE%
REM   Echo.
REM   Echo DxfDwgDest_DP    : %DxfDwgDest_DP%
REM   Echo DxfDwgDest_DPNE  : %DxfDwgDest_DPNE%
REM   Echo PrtDest_DPNE     : %PrtDest_DPNE%
REM   pause

  rem pruefung existierende DXF Files
  if     exist "%DxfDwgSource_DPNE%" goto :DxfExportRun_MovePartToArchivExecute
  if not exist "%DxfDwgSource_DPNE%" goto :DxfExportRun_CreateFileErr

  :DxfExportRun_MovePartToArchivExecute

   rem Zielverzeichnis erzeugen
   if not exist "%DxfDwgDest_DP%" md "%DxfDwgDest_DP%"
   set DXFExpoErrLevel=%errorlevel%
   if not exist "%DxfDwgDest_DP%" goto :DxfExportRun_CreatePathErr

   rem Save "%PrtSource_DPNE%" nicht durchfhren !!
   rem if not exist "%PrtDest_DP%" md "%PrtDest_DP%"
   rem set DXFExpoErrLevel=%errorlevel%
   rem if not exist "%PrtDest_DP%" goto :DxfExportRun_CreatePathErr_PrtDest_DP

   rem Dxf Datei in das Zielverzeichnis verschieben
   Echo moving: Exported DXF File [%ItemName%/%RevName%]
   Echo from: %DxfDwgSource_DPNE%
   Echo   to: %DxfDwgDest_DPNE%

   set toRun=move /Y "%DxfDwgSource_DPNE%" "%DxfDwgDest_DPNE%"
   Echo ##debug
   Echo toRun=%toRun%
   %toRun%
   set DXFExpoErrLevel=%errorlevel%

   rem "%PrtSource_DPNE%" loeschen !!
   set toRun=del /F /Q "%PrtSource_DPNE%"
   if exist "%PrtSource_DPNE%" %toRun%

   if     exist "%DxfDwgDest_DPNE%" goto :DxfExportRun_MovePartToArchivOK
   if not exist "%DxfDwgDest_DPNE%" goto :DxfExportRun_MovePartToArchivErr

   :DxfExportRun_MovePartToArchivOK
    rem --- schreiben der Ergebnisse in den Ergebnisfile
    rem start " " Explorer.exe /select, "%DxfDwgDest_DPNE%"
    call :JobResultsGenericV1_WriteLog  "%ObjectCliName%" "0" "%ExpoDxfDwg_E%-Expo:OK %DxfDwgDest_DPNE%" "" %ItemName% %RevName%
    goto :DxfExportRun_MovePartToArchivEnde

   :DxfExportRun_CreateFileErr
    rem --- schreiben der Ergebnisse in den Ergebnisfile
    call :JobResultsGenericV1_WriteLog  "%ObjectCliName%" "100" "%ExpoDxfDwg_E%-Expo:Err Dxf file:[%DxfDwgDest_DPNE%] cound not be exported" ""
    goto :DxfExportRun_MovePartToArchivEnde

   :DxfExportRun_CreatePathErr
    rem --- schreiben der Ergebnisse in den Ergebnisfile
    call :JobResultsGenericV1_WriteLog  "%ObjectCliName%" "110" "%ExpoDxfDwg_E%-Expo:Err [OS:%DXFExpoErrLevel%] user %userName% creating path [%DxfDwgDest_DP%]" ""
    goto :DxfExportRun_MovePartToArchivEnde

   :DxfExportRun_MovePartToArchivErr
    rem --- schreiben der Ergebnisse in den Ergebnisfile
    call :JobResultsGenericV1_WriteLog  "%ObjectCliName%" "120" "%ExpoDxfDwg_E%-Expo:Err [OS:%DXFExpoErrLevel%] moving part to:[%DxfDwgDest_DPNE%]" ""
    goto :DxfExportRun_MovePartToArchivEnde

   :DxfExportRun_CreatePathErr_PrtDest_DP
    rem --- schreiben der Ergebnisse in den Ergebnisfile
    call :JobResultsGenericV1_WriteLog  "%ObjectCliName%" "130" "%ExpoDxfDwg_E%-Expo:Err [OS:%DXFExpoErrLevel%] user %userName% creating path [%PrtDest_DP%]" ""
    goto :DxfExportRun_MovePartToArchivEnde


   :DxfExportRun_MovePartToArchivEnde
    if exist "%PrtSource_DPNE%" del "%PrtSource_DPNE%"

 endlocal
 goto :eof


rem ---------------------------------------------------------------------------------
:Prt2D_ConvertTo_DxfDwg
  rem erstellt aus einem .Prt File einen einen .Dxf bzw .Dwg  File

  set PrtExport_DPNE=%1.prt
  rem Parsen und zusammensetzen der Dest Dateinamen
  set DxfDwgExport_DPNE=%1.%ExpoDxfDwg_E%
  set DxfDwgExportLog_DPNE=%1_prt_to_%ExpoDxfDwg_E%.log

  rem strip "
  set PrtExport_DPNE=%PrtExport_DPNE:"=%
  set DxfDwgExport_DPNE=%DxfDwgExport_DPNE:"=%
  set DxfDwgExportLog_DPNE=%DxfDwgExportLog_DPNE:"=%

  set DxfDwgExportDef_DPNE=%CurCmdRoot_DP%\dxfdwg_M.def

  Call :ColorSet IsExecuting
  Call :PrintCurrAction "..2D.PRT to %ExpoDxfDwg_E% [%ObjectCliName%] start"

  rem Export DXF Step -- dxfdwg.exe -- erstellt aus UGNative 2D PRT File einen DXF File
  set toRun=call "%UGII_BASE_DIR%\dxfdwg\dxfdwg.exe" "%PrtExport_DPNE%" "%DxfDwgExport_DPNE%"  "%DxfDwgExportLog_DPNE%" "%DxfDwgExportDef_DPNE%"
  rem ## Hier knnte der Tiff Converter eingebaut werden C.Kohler 28.11.2008 ##
  if     exist "%PrtExport_DPNE%" %toRun%
  if not exist "%PrtExport_DPNE%" Echo Err:Prt to %ExpoDxfDwg_E% can not find source .prt
  if not exist "%PrtExport_DPNE%" Echo     [%PrtExport_DPNE%]

  Call :PrintCurrAction "..2D.PRT to %ExpoDxfDwg_E% [%ObjectCliName%] end"

 goto :eof

rem ---------------------------------------------------------------------------------
:ExportUgto2d_doRun_viaDefFile

 rem Startet den Export der Dateien
 rem Echo -----------------------------------------
 rem Echo Inhalt der Defdatei: %DxfExport_Ugto2d_Def_DPNE%

 set toRun=Call "%UGII_BASE_DIR%\UGTO2D\ugto2d.exe" -pim=yes -u=%TceUser% -p=%TceUserPassword% "%DxfExport_Ugto2d_Def_DPNE%"

 Call :PrintCurrAction "NX..3D.PRT to .. 2D.PRT start"
 %toRun%
 set Ugto2dErrorLevel=%Errorlevel%

 rem Error behandlung
 if not "%Ugto2dErrorLevel%"=="0" goto :ExportUgto2d_RoRun_viaDefFile_end_err
 if     "%Ugto2dErrorLevel%"=="0" goto :ExportUgto2d_RoRun_viaDefFile_end_ok

 :ExportUgto2d_RoRun_viaDefFile_end_err
  rem alle als Datasets als Exported mit Error ausgeben %%k=%ObjectCliName%
  call Banner.exe "Ugto2d:Err"
  FOR /F "tokens=1,2,3,4 delims=;" %%i in (%DxfDwgExportList_DPNE%) do call :JobResultsGenericV1_WriteLog  "%%k" "110" "Dxf-Expo:Err Ugto2D.exe ends with ErrCode:%Ugto2dErrorLevel%" ""
  rem pause
  goto :ExportUgto2d_RoRun_viaDefFile_end

 :ExportUgto2d_RoRun_viaDefFile_end_ok
  call Banner.exe "Ugto2d:OK"
  goto :ExportUgto2d_RoRun_viaDefFile_end


 :ExportUgto2d_RoRun_viaDefFile_end
  Call :PrintCurrAction "NX..3D.PRT to .. 2D.PRT end"


 goto :eof

rem ---------------------------------------------------------------------------------
:ExportUgto2d_CreateExpoDefFile
 rem erstellt den ExportDef File fr "%UGII_BASE_DIR%\UGTO2D\ugto2d.exe" d=..
 set INPUT_PARTS_LIST=
 set OUTPUT_PARTS_LIST=

 rem                       1=%%i    2=%%j  3=%%k                     4=  5=    6= 7=%%o
 rem %DxfDwgExportList_DPNE% 90639213;A;@DB/90639213/A/specification/ZD;AP;UGPART;A;ZD
 rem %ItemName%;%RevName%;%ObjectCliName%;%PartTypeSpAp%;%PartType%;%DataSetName%
 rem FOR /F "tokens=1,2,3,4 delims=;" %%i in ("%DxfDwgExportListAllDetails_DPNE%") do call :AddToList INPUT_PARTS_LIST "%%k"
 FOR /F "delims=" %%i in (%DxfDwgExportListAllDetails_DPNE%) do call :AddToList "%%i"

 rem vorne "," abschneiden
 set INPUT_PARTS_LIST=%INPUT_PARTS_LIST:~1%
 set OUTPUT_PARTS_LIST=%OUTPUT_PARTS_LIST:~1%

 rem wenn %%k genommen wird dann wird auch die Kennzeichung fuer SP AP bernommen!
 rem FOR /F "tokens=1,2,4 delims=;" %%i in (%DxfDwgExportList_DPNE%) do call :AddToList OUTPUT_PARTS_LIST "%%i_%%j_%%k.prt"
 rem FOR /F "tokens=1,2,4 delims=;" %%i in (%DxfDwgExportList_DPNE%) do call :AddToList OUTPUT_PARTS_LIST "%%i_%%j.prt"
 rem FOR /F "delims=" %%i in (%DxfDwgExportListAllDetails_DPNE%) do call :AddToList INPUT_PARTS_LIST "%%i"

 Echo !>>"%DxfExport_Ugto2d_Def_DPNE%"
 Echo ! Inputliste for DataExport>>"%DxfExport_Ugto2d_Def_DPNE%"
 Echo ! Job: %JobName% (%Date% %Time%)>>"%DxfExport_Ugto2d_Def_DPNE%"
 Echo ! Createt on \\%ComputerName% OsUser:%UserName%>>"%DxfExport_Ugto2d_Def_DPNE%"
 Echo INPUT_PARTS_DIR =>>"%DxfExport_Ugto2d_Def_DPNE%"
 Echo !>>"%DxfExport_Ugto2d_Def_DPNE%"
 Echo OUTPUT_PARTS_DIR = %DxfDwg_output_DP%>>"%DxfExport_Ugto2d_Def_DPNE%"
 Echo !>>"%DxfExport_Ugto2d_Def_DPNE%"
 Echo DEFAULT_CNV_MODE = MODELING>>"%DxfExport_Ugto2d_Def_DPNE%"
 Echo !>>"%DxfExport_Ugto2d_Def_DPNE%"
 Echo DEFAULT_DRAWING_CNV = _ALL_>>"%DxfExport_Ugto2d_Def_DPNE%"
 rem Echo ASSEM_OPTIONS = ...\ClientScripts\load_options_DataExport.def
 Echo ASSEM_OPTIONS = %UGII_LOAD_OPTIONS%>>"%DxfExport_Ugto2d_Def_DPNE%"
 Echo !>>"%DxfExport_Ugto2d_Def_DPNE%"
 Echo CONVERT_FACET_BODIES = no>>"%DxfExport_Ugto2d_Def_DPNE%"
 Echo !>>"%DxfExport_Ugto2d_Def_DPNE%"
 Echo CONVERT_GDT_AS_GROUP = no>>"%DxfExport_Ugto2d_Def_DPNE%"
 Echo !>>"%DxfExport_Ugto2d_Def_DPNE%"
 Echo DATA_REDUCTION = yes>>"%DxfExport_Ugto2d_Def_DPNE%"
 Echo !>>"%DxfExport_Ugto2d_Def_DPNE%"
 Echo ! List off Datasets to process:>>"%DxfExport_Ugto2d_Def_DPNE%"
 Echo INPUT_PARTS_LIST = %INPUT_PARTS_LIST%>>"%DxfExport_Ugto2d_Def_DPNE%"
 Echo ! List of output Filename: >>"%DxfExport_Ugto2d_Def_DPNE%"
 Echo OUTPUT_PARTS_LIST = %OUTPUT_PARTS_LIST%>>"%DxfExport_Ugto2d_Def_DPNE%"
 Echo.>>"%DxfExport_Ugto2d_Def_DPNE%"

 goto :eof

rem ---------------------------------------------------------------------------------
:AddToList
 rem Addiert eine Element an die Liste
 rem " replace

 Call :DataSetSplit %1

 set INPUT_PARTS_LIST=%INPUT_PARTS_LIST%,%ObjectCliName%
 set OUTPUT_PARTS_LIST=%OUTPUT_PARTS_LIST%,%ItemNameNoBlanks%_%RevNameNoBlanks%.prt


REM  set AddToListTemp=%2
REM  set AddToListTemp=%AddToListTemp:~1,-1%
REM  call :excec set AddToListTemp=%%%1%%,%AddToListTemp%
REM  set %1=%AddToListTemp%
REM  set AddToListTemp=
 goto :eof

rem ---------------------------------------------------------------------------------
:excec
 %*
 goto :eof

rem ---------------------------------------------------------------------------------
:DataSetSplit
 rem Splittet einen JobMgr AllDetails Datensatzes auf

 rem vorne und hinten " abscheiden
 set ObjectInfoLine01=%1
 set ObjectInfoLine01=%ObjectInfoLine01:~1,-1%

 rem Objektdaten extrahieren nach dem 31 ";"
 FOR /F "tokens=31,* delims=;" %%i IN ("%ObjectInfoLine01%") do set ObjectInfoLine32=%%j

 FOR /F "tokens=1 delims=;"  %%i IN ("%ObjectInfoLine01%") do set ItemName=%%i
 FOR /F "tokens=2 delims=;"  %%i IN ("%ObjectInfoLine01%") do set RevName=%%i
 FOR /F "tokens=4 delims=;"  %%i IN ("%ObjectInfoLine01%") do set IrCli=%%i

 FOR /F "tokens=5 delims=;"  %%i IN ("%ObjectInfoLine01%") do set ObjectCliNameForFileSys=%%i
 FOR /F "tokens=9 delims=;"  %%i IN ("%ObjectInfoLine01%") do set PartType=%%i
 FOR /F "tokens=10 delims=;" %%i IN ("%ObjectInfoLine01%") do set ObjectCliName=%%i

 FOR /F "tokens=12 delims=;" %%i IN ("%ObjectInfoLine01%") do set ObjectOwner=%%i
 FOR /F "tokens=13 delims=;" %%i IN ("%ObjectInfoLine01%") do set Group=%%i
 FOR /F "tokens=15 delims=;" %%i IN ("%ObjectInfoLine01%") do set ObjectLastModUser=%%i

 FOR /F "tokens=17 delims=;" %%i IN ("%ObjectInfoLine01%") do set PartTypeSpAp=%%i
 FOR /F "tokens=18 delims=;" %%i IN ("%ObjectInfoLine01%") do set CompCount=%%i
 FOR /F "tokens=21 delims=;" %%i IN ("%ObjectInfoLine01%") do set ObjectFs_DPNE=%%i
 FOR /F "tokens=22 delims=;" %%i IN ("%ObjectInfoLine01%") do set Volume=%%i

 Rem Special Variablen ..NoBlanks
 set ItemNameNoBlanks=%ItemName: =%
 call :ReplaceInvalidChar ItemNameNoBlanks "%ItemNameNoBlanks%"
 set RevNameNoBlanks=%RevName: =%
 call :ReplaceInvalidChar RevNameNoBlanks "%RevNameNoBlanks%"

 if /I "%2"=="Print" call :DataSetCurrPrint
 goto :eof

:DataSetCurrPrint
 Echo IrCli        : %IrCli%
 Echo ItemName     : %ItemName%
 Echo RevName      : %RevName%
 Echo ObjectCliName: %ObjectCliName%

 Echo ItemNameNoBlanks : %ItemNameNoBlanks%
 Echo RevNameNoBlanks  : %RevNameNoBlanks%

 goto :eof


rem ---------------------------------------------------------------------------------
:DataSetsSepToLists
 rem verteilt die Datasets auf die jeweiligen Listen Master Sp Master Ap und DXF
 set /A ObjectNr=%ObjectNr%+1
 call :DataSetSplit %1

 rem ## MaxComp evtl. anpassen !!
 set ApMaxComp=140000

 if /I "%PartType%"=="UGMASTER" goto :AddToNXMasterList
 if /I "%PartType%"=="UGPART"   goto :AddToDXFList
                                goto :AddToNoExportList


 :AddToNXMasterList
  rem %CompCount% bercksichtigen ??
  if /I "%PartTypeSpAp%"=="SP" goto :AddToNXMasterListSP
  if /I "%PartTypeSpAp%"=="AP" goto :AddToNXMasterListAP
                               rem wenn keine SP AP dann AddTONoExportList
                               goto :AddToNoExportList

  :AddToNXMasterListSP
   rem zuordnung zu NXMaster SP Liste
   echo %IrCli%>>"%ExportListNXMasterSP_DPNE%"
   echo %ItemName%;%RevName%;%ObjectCliName%;%PartTypeSpAp%;%PartType%;%DataSetName%;%IrCli%>>"%ExportControlListNXMasterSp_DPNE%"
   echo %ObjectInfoLine01%>>"%ExportControlListNXMasterSpAllDetails_DPNE%"
   echo %ObjectCliName%=[NXMaster:SP]
   goto :eof


  :AddToNXMasterListAP
   rem zuordnung zu NXMaster AP Liste
   echo %IrCli%>>"%ExportListNXMasterAP_DPNE%"
   echo %ItemName%;%RevName%;%ObjectCliName%;%PartTypeSpAp%;%PartType%;%DataSetName%;%IrCli%>>"%ExportControlListNXMasterAP_DPNE%"
   echo %ObjectInfoLine01%>>"%ExportControlListNXMasterApAllDetails_DPNE%"
   echo %ObjectCliName%=[NXMaster:AP]
   goto :eof


  :AddToDXFList
   if %CompCount% GTR %ApMaxComp% goto :AddToNoExportList
   echo %ItemName%;%RevName%;%ObjectCliName%;%PartTypeSpAp%;%PartType%;%DataSetName%>>"%DxfDwgExportList_DPNE%"
   echo %ObjectInfoLine01%>>"%DxfDwgExportListAllDetails_DPNE%"
   echo %ObjectCliName%=[DxfDwgDrawing]
   goto :eof


 :AddToNoExportList
   rem weder UGMASTER noch UGPART also auf die NoExportList
   echo %ItemName%;%RevName%;%ObjectCliName%;%PartTypeSpAp%;%PartType%;%DataSetName%>>"%NoExportList_DPNE%"
   call :JobResultsGenericV1_WriteLog  "%ObjectCliName%" "0" "No-Expo: do not export this Dataset" "" %ItemName% %RevName%
   echo %ObjectCliName%=[Not to Export]
   goto :eof


 goto :eof


rem ---------------------------------------------------------------------
:NxSetEnvironForExport
 rem ## evtl. Suchpath angepasst erforderlich da sonst der refile nicht startet
 rem set Path=%UGII_BASE_DIR%;%UGII_ROOT_DIR%;%Path%

 rem -- UG-Variablen umbiegen --
 set UGII_TMP_DIR=%temp%

 rem LoadOptions setzen
 rem Hinweis: wenn %ExpoSpApType% gesetzt ist dann wird der entsprechende LoadOption File genommen!!
 set UGII_LOAD_OPTIONS=%CurCmdRoot_DP%\load_options_DataExport.def
 if exist %CurCmdRoot_DP%\load_options_DataExport_%ExpoSpApType%.def set UGII_LOAD_OPTIONS=%CurCmdRoot_DP%\load_options_DataExport_%ExpoSpApType%.def

 rem UGMGR_StructureUpdateOnLoad .. onSave = off
 rem ## nur bis NX2
 rem set UGII_DEFAULTS_FILE=%CurCmdRoot_DP%\ug_metric_UGMGR_StructureUpdateOnLoadOnSafe_OFF.def


 set UGII_UGMGR_USE_CACHE=
 set UGII_DISABLE_PREVIEW=on
 set UGII_DISABLE_QAF_NAMED_REFS=on

 rem -- IMAN-Variablen umbiegen --
 rem SET IMAN_SQL_DEBUG=
 set IMAN_TMP_DIR=%temp%
 SET IMAN_KEEP_SYSTEM_LOG=TRUE
 SET UGII_KEEP_SYSTEM_LOG=TRUE
 goto :eof


rem ----------------------------------------------------------------------------
rem !! Parasolid Export !!
rem ----------------------------------------------------------------------------
:ParaSolidExport

 setlocal
  rem P1 = ExportControlListIn_DPNE
  set ExportControlListIn_DPNE=%1
  set ExportControlListIn_DPNE=%ExportControlListIn_DPNE:~1,-1%
  rem P2 = ExportType uebernehmen
  set ExpoSpApType=%2

  set CurActionTitle=ParaSolidExport[%ExpoSpApType%]
  rem Printausgabe
  Call :PrintCurrAction "%CurActionTitle% start"

  set ParaSolidExpo_DP=%temp%\_ParaSolidExpo
  if not exist "%ParaSolidExpo_DP%" md "%ParaSolidExpo_DP%"
  set temp=%ParaSolidExpo_DP%

  set toRunInfo_DPNE=%temp%\_Job_%CurActionTitle%_log.txt

  rem ParaSolid Dateien exportieren lassen
  FOR /F "delims=" %%i in (%ExportControlListIn_DPNE%) do call :ParaSolidExportDoRun "%%i"

  rem Liste der Exportierten Daten mitschreiben
  Dir /N /O:n "%ParaSolidExpo_DP%\*.x_t">>"%toRunInfo_DPNE%" 2>nul

  rem Exportierte ParaSolid Dateien in die Zielverzeichnisse uebertragen Info:hier werden auch die Ergebnisse erstellt
  FOR /F "delims=" %%i in (%ExportControlListIn_DPNE%) do call :ParaSolidExport_MovePartToArchiv "%%i"

  rem Printausgabe
  Call :PrintCurrAction "%CurActionTitle% end"

 endlocal
 goto :eof

rem ----
:ParaSolidExportDoRun
   rem erzeut einen ParaSolidFile
  setlocal

   Call :DataSetSplit %1

   rem entfernt einen bereits laufenden ApiServerProzess
   call "%BinPublic_DP%\ApiServerKill.cmd"

   rem NX Umgebung einstellen
   call :NxSetEnvironForExport

   rem toRun .. fuer UG to ParaSolid zusammensetzen
   Call :ParaSolidExportSetFileNames

   set toRun=
   set toRun=%toRun% "%JobScripts_DP%\NxTools\ParasExpo.exe"
   set toRun=%toRun% -part=%IrCli%
   set toRun=%toRun% -Layer=1,101
   set toRun=%toRun% -ExpoType=%ExpoSpApType%
   set toRun=%toRun% -asInfoFile="%asInfoFile_DPNE%"
   set toRun=%toRun% -paraSolidOutPutFile="%ParaSolidExpoFile_DPNE%"
   set toRun=%toRun% -pim -u=%TceUser% -p=%TceUserPassword%

   echo %toRun%>>%toRunInfo_DPNE%
   %toRun%

  endlocal

 goto :eof
 rem -------------------------

:ParaSolidExportSetFileNames
 rem setzt die ParaSolidExpoFile Namen zusammen Info: es werden die aktuell gesetzten %ItemName%_%RevName% var's verwendet
 set ParaSolidFile_NE=%ItemName%_%RevName%_%ExpoSpApType%.x_t
 set ParaSolidExpoFile_DPNE=%ParaSolidExpo_DP%\%ParaSolidFile_NE%
 set asInfoFile_DPNE=%ParaSolidExpo_DP%\%ItemName%_%RevName%_%ExpoSpApType%.NX_AssemblyStructureFirstLevel_list.txt
 goto :eof


:ParaSolidExport_MovePartToArchiv

  rem schiebt die exportierte ParaSolid Datei in das Zielverzeichnis
  setlocal

   call :DataSetSplit %1
   call :ParaSolidExportSetFileNames

   if     exist "%ParaSolidExpoFile_DPNE%" goto :ParaSolidFile_MoveToArchiv
   if not exist "%ParaSolidExpoFile_DPNE%" goto :ParaSolidFileExportRun_ParaSolidFileExpoErr

   :ParaSolidFile_MoveToArchiv

    rem Zielverzeichnis des ParaSolidFile Files
    call :ExportFileDest_DP_gen ParaSolidFile_Dest_DP ParaSolidDest_DP
    rem Zieldateiname des ParaSolidFile Files inc ExpoType also _SP oder _AP
    set ParaSolidFile_Dest_NE=%ItemName%_%RevName%_%ExpoSpApType%.x_t
    set ParaSolidFile_Dest_DPNE=%ParaSolidFile_Dest_DP%\%ParaSolidFile_Dest_NE%

    rem Zielverzeichnis erzeugen
    if not exist "%ParaSolidFile_Dest_DP%" md "%ParaSolidFile_Dest_DP%">>"%toRunInfo_DPNE%"
    set ParaSolidFileExpoErrLevel=%errorlevel%
    if not exist "%ParaSolidFile_Dest_DP%" goto :ParaSolidFileExportRun_CreatePathErr

    rem ParaSolidFile Datei in das Verzeichnis verschieben
    Echo moving: Exported ParaSolidFile File [%ItemName%/%RevName%]
    Echo from: %ParaSolidExpoFile_DPNE%
    Echo   to: %ParaSolidFile_Dest_DPNE%

    move /Y "%ParaSolidExpoFile_DPNE%" "%ParaSolidFile_Dest_DPNE%">>"%toRunInfo_DPNE%"
    set ParaSolidFileExpoErrLevel=%errorlevel%

    if not "%ParaSolidFileExpoErrLevel%"=="0" goto :ParaSolidFile_MoveToArchivErr
    if     exist "%ParaSolidFile_Dest_DPNE%"  goto :ParaSolidFile_MoveToArchivOK
    if not exist "%ParaSolidFile_Dest_DPNE%"  goto :ParaSolidFile_MoveToArchivErr

    :ParaSolidFile_MoveToArchivOK
     rem --- schreiben der Ergebnisse in den Ergebnisfile
     Set ResultText=ParaSolid-Expo:OK %ParaSolidFile_Dest_DPNE%
     Echo %ResultText%>>"%toRunInfo_DPNE%"
     call :JobResultsGenericV1_WriteLog  "%ObjectCliName%" "0" "%ResultText%" "" %ItemName% %RevName%
     goto :ParaSolidFile_MoveToArchivEnde

    :ParaSolidFileExportRun_ParaSolidFileExpoErr
     rem --- schreiben der Ergebnisse in den Ergebnisfile
     Set ResultText=ParaSolid-Expo:Err ParaSolidFile file:[%ParaSolidFile_NE%] cound not be exported
     Echo %ResultText%>>"%toRunInfo_DPNE%"
     call :JobResultsGenericV1_WriteLog  "%ObjectCliName%" "100" "%ResultText%" "" %ItemName% %RevName%
     goto :ParaSolidFile_MoveToArchivEnde

    :ParaSolidFileExportRun_CreatePathErr
     rem --- schreiben der Ergebnisse in den Ergebnisfile
     Set ResultText=ParaSolid-Expo:Err [OS:%ParaSolidFileExpoErrLevel%] user %userName% creating path [%ParaSolidFile_Dest_DP%]
     Echo %ResultText%>>"%toRunInfo_DPNE%"
     call :JobResultsGenericV1_WriteLog  "%ObjectCliName%" "110" "%ResultText%" "" %ItemName% %RevName%
     goto :ParaSolidFile_MoveToArchivEnde

    :ParaSolidFile_MoveToArchivErr
     rem --- schreiben der Ergebnisse in den Ergebnisfile
     Set ResultText=ParaSolid-Expo:Err [OS:%ParaSolidFileExpoErrLevel%] moving part to:[%ParaSolidFile_Dest_DPNE%]
     Echo %ResultText%>>"%toRunInfo_DPNE%"
     call :JobResultsGenericV1_WriteLog  "%ObjectCliName%" "120" "%ResultText%" "" %ItemName% %RevName%
     goto :ParaSolidFile_MoveToArchivEnde

   :ParaSolidFile_MoveToArchivEnde

  endlocal
 goto :eof



rem ----------------------------------------------------------------------------
rem ----------------------------------------------------------------------------
:ExportFileDest_DP_gen

 rem setzt den Verzeichnissnamen fr die Exportverzeichnisse zusammen
 rem P1=Variable ffuer die bergabe des Zielverzeichniss des Export Verzeichnisses
 rem P2=PrtDest_DP

 call :ReplaceInvalidChar ItemName_l "%ItemNameNoBlanks%"
 call :ReplaceInvalidChar RevName_l "%RevNameNoBlanks%"

 set LastPathExtend_l=

 rem ## Anpassen: Exportzielverzeichnisse festlegen!
 rem    Hinweis: %ExportRoot_DP% wird im Standard von den einstellungen des JobMgr uebernommen
 rem set %1=%ExportRoot_DP%\%ItemName_l:~0,3%\%ItemName_l:~0,6%\%ItemName_l%\%ItemName_l%_%RevName_l%_%LastPathExtend_l%
 rem set %1=%ExportRoot_DP%\%ItemName_l:~0,5%\%ItemName_l%_%RevName_l%
 rem Var 1
 rem set %1=%ExportRoot_DP%\%ItemName_l:~0,5%
 rem set %2=%ExportRoot_DP%_saved_2d_PrtFiles\%ItemName_l:~0,5%\%ItemName_l%_%RevName_l%

 rem Var 2 erstellt 10.5.09
 set %1=%ExportRoot_DP%\%ItemName_l%_%RevName_l%
 set %2=%ExportRoot_DP%_saved_2d_PrtFiles\%ItemName_l%_%RevName_l%

 rem Var 3 erstellt 10.5.09
 set %1=%ExportRoot_DP%
 set %2=%ExportRoot_DP%_saved_2d_PrtFiles


 set ItemName_l=
 set RevName_l=
 set LastPathExtend_l=

 goto :eof



rem ------------------------------------------------------------------
rem ------------------------------------------------------------------

:ReplaceInvalidChar
 setlocal
     rem entfernt alle unzulaessigen Zeichen
     set ReplaceInvalidChar=%2
     set ReplaceInvalidChar=%ReplaceInvalidChar:~1,-1%
     set ReplaceInvalidChar=%ReplaceInvalidChar:-=_%
     rem \ durch _ ersetzen
     set ReplaceInvalidChar=%ReplaceInvalidChar:\=_%
     rem / durch _ ersetzen
     set ReplaceInvalidChar=%ReplaceInvalidChar:/=_%
     rem . durch _ ersetzen
     set ReplaceInvalidChar=%ReplaceInvalidChar:.=_%
     rem " " durch _ ersetzen
     set ReplaceInvalidChar=%ReplaceInvalidChar: =_%

     rem "-" durch _ ersetzen
     set ReplaceInvalidChar=%ReplaceInvalidChar:-=_%

     rem " " durch _ ersetzen
     set ReplaceInvalidChar=%ReplaceInvalidChar:^*=_%
     rem Echo VarName %1 Wert %2 wird zu %ReplaceInvalidChar%
     rem Echo ReplaceInvalidChar=%ReplaceInvalidChar%
     rem pause
 endlocal& set %1=%ReplaceInvalidChar%
 goto :eof

rem ------------------------------------------------------------------

rem ------------------------------------------------------------------
:PrintCurrAction
 rem Ausgabe ber aktuelle Aktion
 rem P1 = AktionInfo
 Set CurrInfo=%myAppl_Title% %1 [%Date:~0,6%%Date:~8,2% %Time:~0,5% %JobName%]
 Title %CurrInfo%
 Echo --------------------------------------------------------------------
 Echo Aktion  : %1 (%Date:~0,6%%Date:~8,2% %Time:~0,5%)
 Echo JobName : %JobName%
 Echo --------------------------------------------------------------------
 goto :eof

:PrintResultMsg
 rem Ausgabe des aktuellen Ergebnisses
 rem P1 = AktionInfo
 setlocal
   set timePrint=%Time:~0,5%
   set timePrint=%timePrint: =0%
   Set CurrInfo=%2 [%Date:~0,6%%Date:~8,2% %timePrint% %JobName%]
   Title %myAppl_Title% Result:%CurrInfo%
   Banner.exe "%1:%timePrint%"
   Echo Result:%CurrInfo%
 endlocal
 goto :eof


rem ------------------------------------------------------------------
:LogFileGen
 rem P1=Varname auf den der LogfileName bergeben wird
 rem P2=Pre/Post ..
 set %1=%temp%\%2.TXT
 goto :eof

:LogFileGenTempOrig
 rem P1=Varname auf den der LogfileName bergeben wird
 rem P2=Pre/Post ..
 set %1=%temp_DP_org%\%2.TXT
 goto :eof


rem ##### ----------- NXDataExport SUBroutines ------------------ ######
rem -----------------------------------------------------------------------
:TCEPromtCmdError
 set ErrLog_DPNE=%temp%\__Err_MissingTcePromtCmd_DeaktivateComputer.txt
 set title_str=ERR: !! cannot start Job on:\\%ComputerName% missing TCEPromptCmd [%Date%/%time:~0,8%] !!
 title %title_str%
 Echo ---------------------------------------------------------------------
 call :ErrLogHeaderWrite
 Echo %title_str%>>"%ErrLog_DPNE%"
 Echo TCEPromtCmd:=%TCEPromtCmd%>>"%ErrLog_DPNE%"

 Type "%ErrLog_DPNE%"
 call :ErrLogFooterWrite
 Echo.
 Echo after press enter you will see the error reason in notepad editor ....
 pause
 start " " Notepad.exe "%ErrLog_DPNE%"
 pause
 goto :end



:ErrLogHeaderWrite
 rem schreibt die erweiterten Infos an einen ErrLogFile
 rem Info: die Variable ErrLog_DPNE muss gesetzt sein!!
 Echo JobClient Error Report  created %date% %time%>>"%ErrLog_DPNE%"
 Echo Computer: %ComputerName% >>"%ErrLog_DPNE%"
 Echo User:     %UserName% >>"%ErrLog_DPNE%"
 Echo --------------------------------------------------------------------->>"%ErrLog_DPNE%"
 goto :eof


:ErrLogFooterWrite
 rem schreibt die erweiterten Infos an einen ErrLogFile
 rem Info: die Variable ErrLog_DPNE muss gesetzt sein!!
 Echo.>>"%ErrLog_DPNE%"
 Echo --------------------------------------------------------------------->>"%ErrLog_DPNE%"
 Echo Environ Info of:\\%ComputerName%>>"%ErrLog_DPNE%"
 Echo.>>"%ErrLog_DPNE%"
 Echo -- Path Environ ----------------------------------------------------->>"%ErrLog_DPNE%"
 set PATH>>"%ErrLog_DPNE%"

 Echo -- UG* Environ ------------------------------------------------------>>"%ErrLog_DPNE%"
 set UG>>"%ErrLog_DPNE%"
 Echo -- IMAN* Environ ---------------------------------------------------->>"%ErrLog_DPNE%"
 set IMAN>>"%ErrLog_DPNE%"
 Echo -- All Environ ------------------------------------------------------>>"%ErrLog_DPNE%"
 set>>"%ErrLog_DPNE%"
 goto :eof

:end
 Echo ---------------------------------------------------------------------
 Echo Info:
 Echo all files in: %temp%
 Echo will be zipt by JobClient and send to JobServer


rem #################################################################################
rem ########## ------------ Standard Subroutines --------------------- ##############

rem ----------------------------------------------------------------------------
:ColorSet
 rem -- cmd Color Farbinfo:
 REM    0 = Schwarz        8 = Dunkelgrau
 REM    1 = Dunkelblau     9 = Blau
 REM    2 = Dunkelgrn     A = Grn
 REM    3 = Blaugrn       B = Zyan
 REM    4 = Dunkelrot      C = Rot
 REM    5 = Lila           D = Magenta
 REM    6 = Ocker          E = Gelb
 REM    7 = Hellgrau       F = Wei

 rem -- Farben nach Status setzen
 rem Gelb Schwarz
 if /I "%1"=="IsExecuting" set JobColorLast=E0
 rem Gelb Schwarz
 if /I "%1"=="IsIdel"      set JobColorLast=E0
 rem Hellgrau Schwarz
 if /I "%1"=="End"         set JobColorLast=70
 if /I "%1"=="Ende"        set JobColorLast=70
 rem Gruen Schwarz
 if /I "%1"=="Ok"          set JobColorLast=A0
 rem Rot Schwarz
 if /I "%1"=="Err"         set JobColorLast=C0

 rem jetzt die Farbe setzen
 if not "%JobColorLast%"=="" color %JobColorLast%
 goto :eof

rem ---------------------------------------------------------------------------------
:ObjectToProcessCound
 rem hochzhlen des Anzahlzhlers
 set /A ObjectsToProcessN=%ObjectsToProcessN%+1
 rem Echo Cli:%ObjectCliName% PartType:%PartTypeSpAp%
 goto :eof

rem -----------------------------------------------------------------------
:JobResultsGenericV1_WriteLog
 rem setlocal
   rem schreibt einen Generic JobProcessResultLog_DPNE Logfile
   rem Festlegung: der Seperator muss immer: #;# sein
   rem die Ergebniszeilen sind aufgebaut nach folgenden Schema:
   rem ObjectNamedId#;#ResultCode#;#ResultMsg
   rem P1 = ObjectNamedId
   rem P2 = ResultCode
   rem P3 = ResultMsg
   rem P4 = Process Options
   rem P5 = Item    = SachNummer
   rem P6 = ItemRev = Revision

   rem festlegen des JobProcessResultLog_DPNE Filenamen
   rem Hinweis: der File muss enden mit  _GenericJobResultsV1.Log
   rem set JobProcessResultLog_DPNE=%temp%\_%JobName%_JobResultsGenericV1.Log
   rem P1+P2 mit strip "
   set P1=%1
   set P1=%P1:"=%
   set P2=%2
   set P2=%P2:"=%
   rem P3+P4 verbleiben wie original uebergeben
   set P3=%3
   set P4=%4
   set ItemName=%5
   set RevName=%6

   Echo %P1%#;#%P2%#;#%P3%#;#%P4%>>%JobProcessResultLog_DPNE%
   if     "%P2%"=="0" goto :JobResultsGenericV1_WriteLog_exitOk
   if not "%P2%"=="0" goto :JobResultsGenericV1_WriteLog_exitErr

   :JobResultsGenericV1_WriteLog_exitOk
    rem Ausgabe in der Console
    call :ColorSet OK
    call :PrintResultMsg "OK" "[OK] Code=[%P2%] CLI=[%P1%]"
                  Echo        MSG=[%P3%] Opt=[%P4%]
    goto :JobResultsGenericV1_WriteLog_myExit

   :JobResultsGenericV1_WriteLog_exitErr
    call :ColorSet Err
    call :PrintResultMsg "ERR!" "[ERR] Code=[%P2%] CLI=[%P1%]"
                    Echo        MSG=[%P3%] Opt=[%P4%]
    goto :JobResultsGenericV1_WriteLog_myExit

   :JobResultsGenericV1_WriteLog_myExit
   Echo ------------------------------------------------------------------------

 rem endlocal
 rem call :Wait 1
 goto :eof


rem -----------------------------------------------------------------------
:PathCutLastDir
 rem schneidet das letzte Verzeichnis Uebergeben path ab
 rem P1 = Name der Variablen
 rem P2 = der bergebene Path
 rem Example : call :PathCutLastDir EntwRoot_LP %~dp0
 rem Example : call :PathCutLastDir MyVar %~dp0

 set PathCutLastDir$temp=%2
 set PathCutLastDir$tempLastChar=%PathCutLastDir$temp:~-1%
 set PathCutLastDir$tempNoBacks=%PathCutLastDir$temp:~0,-1%

 if "%PathCutLastDir$tempLastChar%"=="\" (
   rem "\" abschneiden wenn vorhanden
   call :PathCutLastDirDo PathCutLastDir$tempRes %PathCutLastDir$tempNoBacks%
 ) else (
   rem
   call :PathCutLastDirDo PathCutLastDir$tempRes %PathCutLastDir$temp%
 )
 set PathCutLastDir$tempRes=%PathCutLastDir$tempRes:~0,-1%
 set %1=%PathCutLastDir$tempRes%
 set PathCutLastDir$temp=
 set PathCutLastDirDo$temp1=
 set PathCutLastDir$tempNoBacks=
 set PathCutLastDir$tempNoLastChar=
 set PathCutLastDir$tempLastChar=
 set PathCutLastDir$tempRes=
 goto :eof

:PathCutLastDirDo
 rem hiermit schneiden wir den Path ab
 rem echo.
 rem Echo P1=%1 P2=%2
 set PathCutLastDirDo$temp=%~dp2
 rem "\" abschneiden
 set PathCutLastDirDo$temp1=%PathCutLastDir$temp:~0,-1%
 set %1=%PathCutLastDirDo$temp%
 set PathCutLastDirDo$temp=
 set PathCutLastDirDo$temp1=
 goto :eof

rem -----------------------------------------------------------------------
:DateTimeNowGet
 rem call :DateTimeNowGet
 rem Set File_LPNE=%DatRoot_LP%\MyName-%DateTimeNowFileExt%.txt
 if     "%time:~0,1%"==" " set time-h=0%time:~1,1%
 if not "%time:~0,1%"==" " set time-h=%time:~0,2%

 if     "%time:~3,1%"==" " set time-m=0%time:~4,1%
 if not "%time:~3,1%"==" " set time-m=%time:~3,2%

 set Date-Y=%Date:~6,4%
 set Date-M=%Date:~3,2%
 set Date-D=%Date:~0,2%
 set DateTimeNowFileExt=%Date-Y%-%Date-M%-%Date-D%-%time-h%-%time-m%
 goto :eof


:Wait
 set waitTime=2
 if not "%1"=="" set waitTime=%1
 CHOICE /C:w /N /T:w,%waitTime% warte %waitTime% [sec] oder "w" fuer weiter druecken.
 goto :eof


rem -----------------------------------------------------------------------
rem entfernt ein = aus einem string
:ReplaceSign
 if "%3"=="" echo Syntax: Call :ReplaceSign StringIn CharNew  Newstring& goto :EOF
 setlocal
 set string=%1
 set CharNew=%2
 :again
  set work=%string%
  for /f "Tokens=1* Delims==" %%a in ('@echo %string%') do if "%%b" NEQ "" set string=%%a%CharNew%%%b
  if {%string%} NEQ {%work%} goto again
  rem strip "
  set string=%string:"=%

 endlocal& set %3=%string%
goto :eof

rem -----------------------------------------------------------------------
:Parse_ALL
 rem parst alle File Bezeichner aus
 rem "\" abschneiden
 set Parse_all$temp=%~dp1
 set Parse_all$temp=%Parse_all$temp:~0,-1%
 set %2_DP=%Parse_all$temp%
 set %2_D=%~d1
 rem "\" hinten und vorne abschneiden
 set Parse_all$temp=%~p1
 set Parse_all$temp=%Parse_all$temp:~1,-1%
 set %2_P=%Parse_all$temp%
 set %2_NE=%~nx1
 set %2_N=%~n1
 set %2_E=%~x1
 set %2_DPNE=%1
 set %2_DPN=%~dpn1
 set Parse_all$temp=
goto :eof


rem -----------------------------------------------------------------------
:Echo
 rem Echos Text auf die Console und in eine Datei (wenn angegeben)
 setlocal
   set TextToEcho=%1
   set TextToEcho=%TextToEcho:"=%
   set EchoToFile_DPNE=%2
   set EchoToFile_DPNE=%EchoToFile_DPNE:"=%
   if "%EchoToFile_DPNE%"=="=" set EchoToFile_DPNE=

   rem - Ausgabe Console
   if NOT "%TextToEcho%"=="." Echo %TextToEcho%
   if     "%TextToEcho%"=="." Echo.

   rem - Ausgabe in File
   if "%EchoToFile_DPNE%"=="" goto :EchoEnd
   if NOT "%TextToEcho%"=="." Echo %TextToEcho% >>"%EchoToFile_DPNE%"
   if     "%TextToEcho%"=="." Echo.>>"%EchoToFile_DPNE%"
 :EchoEnd
 endlocal
 goto :eof



