@Echo off
 REM ===========================================================================
 REM Basisscript JobManager V2 fuer den Refile mit NX in der TC Umgebung
 REM (c) J.Feuerstein 24.11.2006
 REM Aenderungs Info:
 REM User    Date/Time (Alt+D)  Infotext:
 REM J.Fes   24.11.2006 J.Fes   Ersterstellung 05.09.2013
 REM J.Fes   14.07.2013 J.Fes   Skript umgestellt auf JS Cmd Tools
 REM J.Fes   19.11.2013 J.Fes   integrate UGII_LOAD_OPTIONS + UGII_LOCAL_USER_DEFAULTS
 REM J.Fes   25.12.2013 J.Fes   result is now returning via: %RfPrgExitCode%
 REM J.FES   21.01.2014 J.Fes   add Process Monitoring
 REM J.FES   12.02.2014 J.Fes   add ResultClassification_DPNE
 REM J.FES   29.04.2014 J.Fes   add JobMgr_RfExtEvalROpt
 REM J.FES   29.04.2014 J.Fes   setlocal endlocal partial removed
 REM ===========================================================================

 Echo **************************************************************************
 Echo * Excuting Refile Script for  PLMJobManager Environ                      *
 Echo * Version: 2.7 addPLM GmbH  12.02.2014 (c)                               *
 Echo **************************************************************************

setlocal
 call Echo "--- #Step: Set Up Base ---------------------------------------------------------"

 set JobMgr_TcUser=%~1
 set JobMgr_TcPw=%~2
 set JobMgr_TcGroup=%~3
 if not defined JobMgr_TcGroup set JobMgr_TcGroup=dba

 REM -- #Step: Farbe setzen IsIdel
 call :ColorSet IsIdel

 REM -- Rootpfade setzen -------------------------------------------------------
 set CmdCurRoot_DP=%~dp0
 set CmdCurRoot_DP=%CmdCurRoot_DP:~0,-1%

 rem -- #Step: JobMgr CmdTools local kopieren ----------------------------------
 rem -- #Doc: Steuert aus welchem Bereich die Tools genommen werden J.Fes 14.02.2013
 set JobManagerCmdTools_DP=%JobManagerRoot_DP%\03-BinPublic.ClientServer

 set BinL_DP=%CmdCurRoot_DP%\..\BinL
 if not exist "%BinL_DP%" md "%BinL_DP%"
 Call Echo "TcUser/Group.......: [%JobMgr_TcUser%/%JobMgr_TcGroup%]"
 Call Echo "Upd. JobMgrCmd BinL: [%BinL_DP%]"
 Call Echo "from...............: [%JobManagerCmdTools_DP%]"

 set JobManagerCmdTools_L=%BinL_DP%\JobManagerCmdTools.exe
 set robocopy_opt=/R:5 /W:5
 robocopy %robocopy_opt% /NP /NJS /NJH /NDL /NFL "%JobManagerCmdTools_DP%" "%BinL_DP%" "JobManagerCmdTools.exe">nul 2>nul

 rem new 21.01.2014
 set JFProcessMonitorL_exe=%BinL_DP%\JFProcessMonitor.exe
 robocopy %robocopy_opt% /NP /NJS /NJH /NDL /NFL "%BinPublic_DP%" "%BinL_DP%" "JFProcessMonitor.exe"


 REM -- temp dir Organiesieren -------------------------------------------------
 rem #New: 11.07.2013 13:43 S.Gue
 set JobTemp1_SO_DP=%CmdCurRoot_DP%\JobTempSO
 set JobTemp2_RO_DP=%CmdCurRoot_DP%\JobTempRO
 set RfLogFile_NE=_Rf20_RefileJob.log
 set RfFailedLog_NE=_Rf21_RefileFailed.log
 set RfCmdJobLog_NE=_Rf23_RefileCmdJob.log

 rem #New 30.11.2013 /J.Fes
 set ExtractJobList_MsgLog_DPNE="%CmdCurRoot_DP%\JobData1_ExtractList.log"
 set EvaluateJobResult_MsgLog_DPNE="%CmdCurRoot_DP%\JobData2_ResultEvaluate.log"

 REM -- define cmd files to set the right variables ----------------------------
 set RfSetEnv_SO_cmd=%CmdCurRoot_DP%\RfSetEnv_SO.cmd
 set RfSetEnv_RO_cmd=%CmdCurRoot_DP%\RfSetEnv_RO.cmd
 set RfCustomSetEnv_cmd=%CmdCurRoot_DP%\RfCustomSetEnv.cmd

 set JobMgr_ResClRules_DPNE=%CmdCurRoot_DP%\Resources\RfNxSylog_ResClRules.xml

 REM -- RefilePaketFile festlegen
 set RfInputList_NE=_Rf01_RefileIrList.txt
 set RfInputList1_SO_DPNE=%JobTemp1_SO_DP%\%RfInputList_NE%
 set RfInputList2_RO_DPNE=%JobTemp2_RO_DP%\%RfInputList_NE%

 REM -- Refile Logfiles fr Owning Site festlegen ------------------------------
 set RfLogFile1_SO_DPNE=%JobTemp1_SO_DP%\%RfLogFile_NE%
 set RfFailedLog1_SO_DPNE=%JobTemp1_SO_DP%\%RfFailedLog_NE%
 set RfCmdJobLog_SO_DPNE=%JobTemp1_SO_DP%\%RfCmdJobLog_NE%

 REM -- Refile Logfiles fr Replica festlegen ----------------------------------
 set RfLogFile2_RO_DPNE=%JobTemp2_RO_DP%\%RfLogFile_NE%
 set RfFailedLog2_RO_DPNE=%JobTemp2_RO_DP%\%RfFailedLog_NE%
 set RfCmdJobLog_RO_DPNE=%JobTemp2_RO_DP%\%RfCmdJobLog_NE%

 REM -- Option: Control software starten ---------------------------------------
 rem #Doc: 30.11.2013 / Jfes New
 if /I "%JobMgr_use_PLMJobManagerWatchDog%" equ "ON" (
       REM WatchDog starten !!
       REM Echo Check Start: PLMJobManagerWatchDog.exe
       Echo --------------------------------------------------------------------------
       call "ProgStart_If_NotRuning.cmd" "PLMJobManagerWatchDog" "%BinPublic_DP%\PLMJobManagerWatchDog_Start.cmd"
 )

 REM new 31.05.2010 21:53
 if /i "%JobMgr_use_TcServerKill%" equ  "ON" (
   call ProgIs_Running.cmd  teamcenter teamcenter_Is_running
   if "%teamcenter_Is_running%" equ "0" (
     REM TcServer Process beenden aber nur wenn TeamCenter nicht aktive ist
     call ProgKill.cmd TcServer "#12-Data#\Refile_TcServerStop_log.txt"
    )
 )


 call Echo "--- #Step: Extract Refile IR list ----------------------------------------------"
 call :ExtractRefileIrList

if not exist "%RfInputList1_SO_DPNE%" goto :JumbOver_RfSO
 echo.
 call Echo "--- #Step: Refile Site Owning (SO) ---------------------------------------------"
 rem #Doc: JobParameter is to set on this line
 call :ExecuteRefile "%JobTemp1_SO_DP%" "%RfLogFile1_SO_DPNE%" "%RfFailedLog1_SO_DPNE%" "%RfCmdJobLog_SO_DPNE%" "%RfInputList1_SO_DPNE%" "%RfSetEnv_SO_cmd%" "%RfCustomSetEnv_cmd%" "NO"
:JumbOver_RfSO

if not exist "%RfInputList2_RO_DPNE%" goto :JumbOver_RfRO
 echo.
 call Echo "--- #Step: Refile Replica Objects (RO) -----------------------------------------"
 call :ExecuteRefile "%JobTemp2_RO_DP%" "%RfLogFile2_RO_DPNE%" "%RfFailedLog2_RO_DPNE%" "%RfCmdJobLog_RO_DPNE%" "%RfInputList2_RO_DPNE%" "%RfSetEnv_RO_cmd%"  "%RfCustomSetEnv_cmd%" "YES"
:JumbOver_RfRO

 echo.
 call Echo "--- #Step: Evaluate Refile Results ---------------------------------------------"
 call :EvaluateRefileResult

 endlocal& set RfPrgExitCode=%RfPrgExitCode%
goto :end


rem ============================================================================
:ExecuteRefile

 rem #Doc get File Params
 set temp=%~1
 rem #New 15.04.2014 13:48
 set tmp=%temp%
 set HOME=%temp%

 set RfJobLog_DPNE=%~2
 set RfFailedLog_DPNE=%~3
 set RfCmdJobLog_DPNE=%~4
 set RfPaket_DPNE=%~5
 set RfSetEnv_SORO_cmd=%~6
 set RfCustomSetEnv_cmd=%~7
 set RfReplica=%~8


 REM #Doc: 28.10.2010 J.Feuerstein
 REM #Doc: Achtung wenn FMS_HOME nicht definiert dann entstehen erhebliche
 REM #Doc: fehler beim refile von Baugruppen FMS_HOME=%Tc_Root%\fcc
 if not exist "%FMS_HOME%" call :FMS_HOME_ERR& goto :Rf_end

 REM -- am Ende "\"  abschneiden
 if "%UGII_BASE_DIR:~-1%" equ "\" set UGII_BASE_DIR=%UGII_BASE_DIR:~0,-1%
 if "%UGII_ROOT_DIR:~-1%" equ "\" set UGII_ROOT_DIR=%UGII_ROOT_DIR:~0,-1%
 REM -- Suchpath angepasst erforderlich da sonst der refile nicht startet
 set Path=%UGII_BASE_DIR%;%UGII_ROOT_DIR%;%Path%

 set UGII_TMP_DIR=%temp%
 set UGII_UGSOLIDS_TMP=%UGII_TMP_DIR%

 REM For NX85 disable eingefuegt 17.08.2012 J.Fes / K.S
 set UGII_UGMGR_USE_CACHE=

 REM -- Sysmmetric Multi-Processing (SMP) --------------------------------------
 REM diabled 07.02.2011
 set UGII_SMP_ENABLE=

 REM -- CGM erstellung deaktiveren eingefuegt 09.02.2010 J.fes
 set UGII_IMAGE_CREATE_CGM=
 set UGII_IMAGE_CREATE_CGM_DRAW=
 set UGII_IMAGE_CREATE_CGM_OPTIONS=
 set UGII_IMAGE_CREATE_NAME=
 set UGII_IMAGE_CREATE_ORIGINAL_BACKGROUND=

 REM -- PFM vermeidet fehler beim refile von PFM Parts eingefuegt 29.11.2010 Info erhalten ber IR1814812
 set UGII_UGMGR_ALLOW_PFM_IMPORT_EXPORT=1

 REM -- IMAN-Variablen umbiegen -------------------------------------------
 SET IMAN_SQL_DEBUG=
 set IMAN_TMP_DIR=%temp%
 SET IMAN_KEEP_SYSTEM_LOG=TRUE
 SET UGII_KEEP_SYSTEM_LOG=TRUE
 SET IMAN_Journalling=OFF
 SET IMAN_journaling=OFF
 SET IMAN_TRACEBACK=OFF
 SET IMAN_Journal_Modules=NONE
 SET API_JOURNAL=NONE
 set APB_SCHEMA=

 REM -- TC-Variablen umbiegen -------------------------------------------
 REM 11.08.2010 16:44SQL Debug on for Test's
 SET TC_SQL_DEBUG=
 set TC_TMP_DIR=%temp%
 SET TC_KEEP_SYSTEM_LOG=TRUE
 SET TC_Journalling=OFF
 SET TC_Journaling=OFF
 SET TC_TRACEBACK=OFF

 rem new 12.07.2013 16:29
 set TC_SHARED_MEMORY_DIR=%CmdCurRoot_DP%\..\TC_SHARED_MEMORY_%TcSiteId%
 if not exist "%TC_SHARED_MEMORY_DIR%" md "%TC_SHARED_MEMORY_DIR%"


 REM -- define Load_options -----------------------------------------------
 set UGII_LOAD_OPTIONS=%CmdCurRoot_DP%\startup\load_options_refile.def

 REM -- define nx_refile.dpv -----------------------------------------------
 SET UGII_LOCAL_USER_DEFAULTS=%CmdCurRoot_DP%\startup\nx_refile.dpv
 set UGII_USER_DIR=%CmdCurRoot_DP%
 set UGII_GROUP_DIR=


 REM -- Use TcNx Debug Variables -------------------------------------------------
 if /I "%JobMgr_TcNxDebug%" neq "ON" goto :JumbOver
   Banner TcNxDeb:ON
   set TC_Journalling=ON
   set TC_Journal_Modules=ALL
   set TC_TRACEBACK=ON

   REM -- (Note the small j and single l)
   set TC_journaling=ON
   REM  (Make sure it is N and not ON)
   set TC_POM_JOURNALLING=N
   set TC_Journal_Modules=ALL
   set TC_SQL_DEBUG=BJTP

   REM -- (SUMMARY for shorter list)
   set TC_JOURNAL=FULL
   set TC_JOURNAL_LINE_LIMIT=0
   set TC_DATASET_DEBUG=on
   set JOURNAL_dpat_report=on

   REM -- this variable prints the SOA based server calls timing information into the syslog
   set UGII_UGMGR_MONITOR_NETWORK_CALLS=1
   set UGII_DEBUG=OCC_update_structure
   set TC_SLOW_SQL=-1
   set TC_KEEP_SYSTEM_LOG=true
   set WhereReferencePOMPref=1
   REM !! Attention !!
   REM set UGII_CHECKING_LEVEL=1
:JumbOver


 rem 21.01.2014
 rem Monitors NxCB_program_exe_NE
 rem  - mit max 2 Std Laufzeit
 rem  - mit max 6gb Memory usage fr 5 min
 rem  - mit max 5 min ohne das neue files im JobTemp entstehen oder editiert werden

 set toMon=%JFProcessMonitorL_exe%
 set toMon=%toMon% --waitForProcess 10000
 set toMon=%toMon% --processName ugmanager_refile_program
 set toMon=%toMon% --parentProcessId 0
REM  set toMon=%toMon% --runtimeLimitSeconds 7200
 set toMon=%toMon% --killChildProcesses
 set toMon=%toMon% --fileLastWriteTime "%temp%\*.*;600"
REM  set toMon=%toMon% --memoryUsageHigh 6000;300
 set toMon=%toMon% --saveResultsTo "%temp%\zzJFProcessMonitor_log.xml"
 set toMon=%toMon% --tailTextFile "%temp%\%username%*.syslog"
 set toMon=%toMon% --titlePrefix "Job:[%JobName%][%TcSiteId%]"


 rem Rf Parameter festlegen
 set RfPara=#JobParameter#

 REM -- set Rf.Appl.Environ RO/SO  file --
 if exist "%RfSetEnv_SORO_cmd%" call "%RfSetEnv_SORO_cmd%"

 if /I "%RfReplica%"    neq "YES" goto :JumbOver
 if /i "%JobMgr_Debug%" neq "ON"  goto :JumbOver
  Echo #Debug: Check if RfPara contains......: [-replica_bypass=yes]
  Echo RfPara................................: [%RfPara%]
  Echo RfReplica.............................: [%RfReplica%]
  Echo UGII_UGMGR_ALLOW_REFILE_REPLICA_BYPASS: [%UGII_UGMGR_ALLOW_REFILE_REPLICA_BYPASS%]
  pause
:JumbOver

 if /I "%RfPara%" equ "%RfPara: -update_mod_props=no=%" goto :JumbOver
    REM #Doc: 01.06.2011 Info from Phil.K
    SET TC_UPDATE_MOD_PROPS=NO
:JumbOver

 REM -- set Custom.Appl.Environ Custom from cmd file --
 if exist "%RfCustomSetEnv_cmd%" call "%RfCustomSetEnv_cmd%"

 REM -- Refile Programm --------------------------------------------------------
 set refile_program_exe_DPNE=%UGII_BASE_DIR%\UGMANAGER\ugmanager_refile_program.exe
 if not exist "%refile_program_exe_DPNE%" call :Refile_program_exe_DPNE_ERR& goto :Rf_end

 call :Parse_ALL %UGII_LOAD_OPTIONS% UGII_LOAD_OPTIONS
 call :Parse_ALL %UGII_LOCAL_USER_DEFAULTS% UGII_LOCAL_USER_DEFAULTS

 call :ColorSet IsExecuting

 set titleRf_str=Job:[%JobName%][%TcSiteId%][Replica:%RfReplica%][%Date% %time:~0,5%][\\%ComputerName%]
 title %titleRf_str%

 Echo.                                                                               .
 Echo %titleRf_str%
 Echo ----------------------------------------------------------------------------
 Echo RefileJob Info:
 Echo JobName.............: %JobName%
 Echo Computer............: %ComputerName%
 Echo Refile Environ......:
 Echo RfDir...............: %temp:~-50%
 Echo TcSide..............: #TcSite.SiteInfoWith_SiteId_and_pName#
 Echo TcUser..............: %JobMgr_TcUser%
 Echo FMS_HOME............: %FMS_HOME%
 Echo TC_ROOT.............: %TC_ROOT%
 Echo TC_DATA.............: %TC_DATA%
 Call :JobParam_List "Refile Parameter....:" "%RfPara%"
 Echo Special Options.....:
 Echo RfReplicaParts......: %RfReplica%
 Echo RfEvalExtOpt........: %JobMgr_RfExtEvalROpt%
 Echo UGII_LOAD_OPTIONS...: ..\%UGII_LOAD_OPTIONS_NE%
 Echo UGII_SITE_DIR.......: %UGII_SITE_DIR%
 Echo UGII_LOCAL_USER_DEF.: ..\%UGII_LOCAL_USER_DEFAULTS_NE%

 REM Echo UGII_GROUP_DIR..: %UGII_GROUP_DIR%
 REM Echo UGII_USER_DIR...: %UGII_USER_DIR%

 cd /d "%temp%"
 Echo ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----
 call :fccCheck
 Echo ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----
 Echo Refile Protocol:
 REM -- hier wird das Refileprogram gestartet --
 set >>"%temp%\zzEnvironBevorRefile.txt"
 start "Job:[%JobName%][%TcSiteId%] PMon" %toMon%
 call "%refile_program_exe_DPNE%" %RfPara% -i="%RfPaket_DPNE%" -log="%RfJobLog_DPNE%" -out="%RfFailedLog_DPNE%" -u=%JobMgr_TcUser% -p=%JobMgr_TcPw% -g=%JobMgr_TcGroup%
 set RfPrgExitCode=%errorlevel%
 call Echo "--- #Res.: RfPrgExitCode.: [%RfPrgExitCode%] -------------------------------------------------"


 Echo ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----  ----
 Banner "Rf:End"

 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOver
   Echo #Debug Refile Results Info:
   Echo RfPrg........: %refile_program_exe_DPNE%
   Echo RfPrgExitCode: %RfPrgExitCode%
   Call :TypeFile "%RfCmdJobLog_DPNE%"  "Rf Cmd Log:"
   Call :TypeFile "%RfJobLog_DPNE%"     "Rf Job Log:"
   Call :TypeFile "%RfFailedLog_DPNE%"  "Rf Failed Log:"
   pause
:JumbOver
 if defined title_str title %title_str%

 Echo CleanUp......: %temp%\%userName%2TierTransientVolume\..
 rd /S /Q  "%temp%\%userName%2TierTransientVolume" >nul 1>nul 2>nul

 if "%RfPrgExitCode%" neq "0" goto :RfPrgExitWith_ERR

:RfPrgExit_OK
 REM set Color OK da refile_program_exe_DPNE beendet werden konnte
 Call :ColorSet OK
 REM -- alle Files loeschen die nicht zum JobServer gesendet werden sollen
 REM    aber nicht wenn eines der bedingungen:JobMgr_Debug='ON' or JobMgr_TcNxDebug='ON'
 if /I "%JobMgr_TcNxDebug%" neq "ON" (
       if /I "%JobMgr_Debug%" neq "ON" (
          Echo CleanUp......: %temp%\..
          del /S /Q "%temp%\apiserver.exe*.*","%temp%\*.bak","%temp%\*.tmp","%temp%\*.prt","%temp%\tcserver.*","%temp%\tcserver.*.*">nul 1>nul 2>nul
       )
 )
 goto :Rf_end


:RfPrgExitWith_ERR
 call :RfPrgExitWith_ERR
 goto :Rf_end

:Rf_end
 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
    Echo.
    Echo #Debug:%~0 [Rf:End]
    pause
:JumbOverDebug

goto :eof

REM ============================================================================
:ExtractRefileIrList
 rem #Doc: Extracts the IR lists for Refile input
 rem #New: 15.07.2013

 Call :ColorSet ExtractLi

 set toRun=%JobManagerCmdTools_L%
 set toRun=%toRun% -Action "RefileTC_2012_01"
 set toRun=%toRun% -SubAction "EXTRACT"
 set toRun=%toRun% -JobRoot_DP "%CmdCurRoot_DP%"
 set toRun=%toRun% -JobTemp1_SO_DP "%JobTemp1_SO_DP%"
 set toRun=%toRun% -JobTemp2_RO_DP "%JobTemp2_RO_DP%"
 set toRun=%toRun% -RfInputList1_SO_DPNE "%RfInputList1_SO_DPNE%"
 set toRun=%toRun% -RfInputList2_RO_DPNE "%RfInputList2_RO_DPNE%"
 set toRun=%toRun% -JobData1ToProcessDoPrint
REM  set toRun=%toRun% -MsgLog_DPNE "%ExtractJobList_MsgLog_DPNE%"

 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
   set Debug_DPNE=%CmdCurRoot_DP%\zzDebug_01_ExtractIrList.txt
   set toRun=%toRun% -verbose -pauseOnEnd
   Echo #Debug.: BEVOR: [%~0]
   Echo %toRun% >>"%Debug_DPNE%"
   Echo %toRun%
   set toRunForPrint=%toRun:"=%
   call Echo " %~0 toRun:%toRunForPrint% " "" "NOECHO"
:JumbOverDebug

 call %toRun%

goto :eof

rem ============================================================================
:EvaluateRefileResult
 rem #Doc: Evaluate the refile results
 rem #New: 15.07.2013

 Call :ColorSet EvalResult

 set toRun=%JobManagerCmdTools_L%
 set toRun=%toRun% -Action "RefileTC_2012_01"
 set toRun=%toRun% -SubAction "EVALUATE"
 set toRun=%toRun% -JobRoot_DP "%CmdCurRoot_DP%"
 set toRun=%toRun% -JobData2ResultsDoPrint
 rem #New:12.02.2014/J.Fes
 if exist "%JobMgr_ResClRules_DPNE%" set toRun=%toRun% -ResultClassification_DPNE "%JobMgr_ResClRules_DPNE%"
 rem #New:28.04.2014/J.Fes
 if defined JobMgr_RfExtEvalROpt set toRun=%toRun% %JobMgr_RfExtEvalROpt%

 if /i "%JobMgr_Debug%" neq "ON" goto :JumbOverDebug
   set Debug_DPNE=%CmdCurRoot_DP%\zzDebug_03_EvaluateRefileResult.txt
   set toRun=%toRun% -verbose -pauseOnEnd
   Echo #Debug.: BEVOR: [%~0]
   Echo %toRun% >>"%Debug_DPNE%"
   Echo %toRun%
   set toRunForPrint=%toRun:"=%
   call Echo " %~0 toRun:%toRunForPrint% " "" "NOECHO"
:JumbOverDebug

 call %toRun%

goto :eof


REM ####### ------------ Standard Subroutines ---------------------- ###########
REM ============================================================================
:JobParam_List
 setlocal
  set ParmListTitle=%~1
  set JobParams=%~2
  rem " ersetzen durch '
  set JobParams=%JobParams:"='%
  set NCur=0
:JobParam_List_PrintNext
  set /a NCur=%NCur%+1
  FOR /F "tokens=%NCur% delims=-" %%i IN ("%JobParams%") do Call :JobParam_Print "%%i"
  if %NCur% LEQ 10 goto :JobParam_List_PrintNext
 endlocal
 goto :eof

:JobParam_Print
 setlocal
  set JobParaCur=%~1
  if "%NCur%" equ "1" (
                            Echo %ParmListTitle% -%JobParaCur%
  ) else (
   if "%JobParaCur%" neq "" Echo                     : -%JobParaCur%
  )
 endlocal
 goto :eof

REM ============================================================================
:fccCheck
 rem #New 28.06.2013 J.Fes
 call fccstat -status>"%temp%\zzfcc1Status.log"
 set tc_fccstatus=%errorlevel%

 if "%tc_fccstatus%" equ "0" goto :fccStartOk

  rem jetzt fcc starten
  call fccstat -start>"%temp%\zzfcc2Start.log"

  rem fcc preufung nach start
  call fccstat -status>"%temp%\zzfcc3Status.log"
  set tc_fccstatus=%errorlevel%

  if "%tc_fccstatus%" equ "0" goto :fccStartOk

  Call :ColorSet ERR
  rem der fcc kann nicht gestartet werden dann Prozess anhalten
  Echo - - - - - - - - - - - - - - - - - - - - - -
  Echo Error fcc cannot be started
  Echo.
  Echo --- Content of fcc zzfcc1Status.log ---
  type "%temp%\zzfcc1Status.log"
  Echo --- Content of fcc zzfcc2Start.log ----
  type "%temp%\zzfcc2Start.log"
  Echo --- Content of fcc zzfcc3Status.log ---
  type "%temp%\zzfcc3Status.log"
  Echo.
  Echo Please check installation and configuration
  Echo !! -- Job not done -- !!
  Echo - - - - - - - - - - - - - - - - - - - - - -
  pause
  Exit

 :fccStartOk
  del "%temp%\zzfcc1Status.log"
  Echo fcc check:OK on \\%ComputerName%

goto :eof

REM ============================================================================
:RfPrgExitWith_ERR
 Call :ColorSet ERR
 set ErrLog_DPNE=%temp%\__Err_RefileProgramResultErr.txt
 set title_str=ERR:%RfPrgExitCode% !! error running ugmanager_refile_program.exe [%Date%/%time:~0,8%] !!
 title %title_str%
 call :ErrLogHeaderWrite
 Echo --------------------------------------------------------------------------
 Echo %title_str%>>"%ErrLog_DPNE%"
 Echo Refile Prog.........: %refile_program_exe_DPNE% >>"%ErrLog_DPNE%"
 Echo ends with Err Level.: %RfPrgExitCode% >>"%ErrLog_DPNE%"

 call :ErrLogFooterWrite

 REM Exit wenn nicht auf dem Client das Ergebniss angezeigt werden soll
 if /I "%JobMgr_OnErrorShowResultOnClient%" neq "ON" goto :RfPrgExitWith_ERR_end

 Type "%ErrLog_DPNE%"
 Echo.
 Echo after press enter you will see the error reason in notepad editor ....
 Echo Info: explorer start's with dir %temp%
 pause
 start "" Notepad.exe "%ErrLog_DPNE%"
 start "" Explorer "%temp%"
 Echo #Hint: type exit and script continues
 cmd
 goto :RfPrgExitWith_ERR_end

:RfPrgExitWith_ERR_end
goto :eof

REM ============================================================================
:Refile_program_exe_DPNE_ERR
 Call :ColorSet ERR
 set ErrLog_DPNE=%temp%\__Err_Missing_Refile_Program.Exe_DeaktivateComputer.txt
 set title_str=ERR: !! cannot start refile on: [\\%ComputerName%] missing refile_program.exe [%Date%/%time:~0,8%] !!
 call :ErrLogHeaderWrite
 title %title_str%
 Echo --------------------------------------------------------------------------
 call :ErrLogHeaderWrite
 REM Error in die Datei schreiben!
 Echo %title_str%>>"%ErrLog_DPNE%"
 Echo refile_program_exe_DPNE:=%refile_program_exe_DPNE%>>%temp%\__ErrorUp-ReadMeFirst-DeaktivateComputer.txt>>"%ErrLog_DPNE%"

 Type "%ErrLog_DPNE%"
 call :ErrLogFooterWrite

 REM Exit wenn nicht auf dem Client das Ergebniss angezeigt werden soll
 if /i "%JobMgr_OnErrorShowResultOnClient%" neq "ON" goto :Refile_program_exe_DPNE_ERR_end

 Echo.
 Echo after press enter you will see the error reason in notepad editor ....
 Echo Info: explorer start's with dir %temp%
 pause
 start "" Notepad.exe "%ErrLog_DPNE%"
 start "" Explorer "%temp%"
 Echo #Hint: type exit and script continues
 cmd
 goto :Refile_program_exe_DPNE_ERR_end

:Refile_program_exe_DPNE_ERR_end
goto :eof

REM ============================================================================
:FMS_HOME_ERR
 Call :ColorSet ERR
 set ErrLog_DPNE=%temp%\__Err_FMS_HOME_DeaktivateComputer.txt
 set title_str=ERR: !! cannot start refile on:\\%ComputerName%  FMS_HOME:[%FMS_HOME%] Dir Not found [%Date%/%time:~0,8%] !!
 title %title_str%
 Echo --------------------------------------------------------------------------
 call :ErrLogHeaderWrite
 Echo %title_str%>>"%ErrLog_DPNE%"
 Echo FMS_HOME Dir not foundFMS_HOME:[%FMS_HOME%] Dir Not found >>"%ErrLog_DPNE%"

 Type "%ErrLog_DPNE%"
 call :ErrLogFooterWrite
 REM Exit wenn nicht auf dem Client das Ergebniss angezeigt werden soll
 REM if /i "%JobMgr_OnErrorShowResultOnClient%" neq "ON" goto :FMS_HOME_ERR_end

 Echo.
 Echo after press enter you will see the error reason in notepad editor ....
 Echo Info: explorer start's with dir %temp%
 pause
 start "" Notepad.exe "%ErrLog_DPNE%"
 start "" Explorer "%temp%"
 Echo #Hint: type exit and script continues
 cmd
 goto :FMS_HOME_ERR_end
:FMS_HOME_ERR_end
goto :eof


REM ============================================================================
:ErrLogHeaderWrite
 REM schreibt die erweiterten Infos an einen ErrLogFile
 REM Info: die Variable ErrLog_DPNE muss gesetzt sein!!
 Echo JobClient ERROR Report created %date% %time%>>"%ErrLog_DPNE%"
 Echo Computer: %ComputerName% >>"%ErrLog_DPNE%"
 Echo User....: %UserName% >>"%ErrLog_DPNE%"
 Echo -------------------------------------------------------------------------->>"%ErrLog_DPNE%"
 goto :eof

REM ============================================================================
:ErrLogFooterWrite
 REM schreibt die erweiterten Infos an einen ErrLogFile
 REM Info: die Variable ErrLog_DPNE muss gesetzt sein!!
 Echo.>>"%ErrLog_DPNE%"
 Echo -------------------------------------------------------------------------->>"%ErrLog_DPNE%"
 Echo Environ Info of:\\%ComputerName% >>"%ErrLog_DPNE%"
 Echo.>>"%ErrLog_DPNE%"
 Echo -- Path Environ ---------------------------------------------------------->>"%ErrLog_DPNE%"
 set PATH>>"%ErrLog_DPNE%"

 Echo -- UG* Environ ----------------------------------------------------------->>"%ErrLog_DPNE%"
 set UG>>"%ErrLog_DPNE%"
 Echo -- NX* Environ ----------------------------------------------------------->>"%ErrLog_DPNE%"
 set NX>>"%ErrLog_DPNE%"
 Echo -- IMAN* Environ --------------------------------------------------------->>"%ErrLog_DPNE%"
 set IMAN>>"%ErrLog_DPNE%"
 Echo -- TC* Environ ----------------------------------------------------------->>"%ErrLog_DPNE%"
 set TC>>"%ErrLog_DPNE%"
 Echo -- All Environ ----------------------------------------------------------->>"%ErrLog_DPNE%"
 set>>"%ErrLog_DPNE%"
 goto :eof

REM ============================================================================
:ColorSet
Rem Stand 25.06.2011
Rem Examples:
 REM call :ColorSet Standard
 REM call :ColorSet IsExecuting
 REM call :ColorSet IsIdel
 REM call :ColorSet End
 REM call :ColorSet Ende
 REM call :ColorSet Ok
 REM call :ColorSet Err

 if /I "%~1" equ "Standard"    set JobColorLast=70
 if /I "%~1" equ "IsExecuting" set JobColorLast=E0
 if /I "%~1" equ "ExtractLi"   set JobColorLast=B0
 if /I "%~1" equ "EvalResult"  set JobColorLast=B1
 if /I "%~1" equ "IsIdel"      set JobColorLast=70
 if /I "%~1" equ "End"         set JobColorLast=70
 if /I "%~1" equ "Ende"        set JobColorLast=70
 if /I "%~1" equ "Ok"          set JobColorLast=A0
 if /I "%~1" equ "Err"         set JobColorLast=C0

 REM set color
 if "%JobColorLast%" neq "" color %JobColorLast%
 goto :eof

REM ============================================================================
:TypeFile
 REM Types the description and the contens of a file
 setlocal
  set FileToType_DPNE=%~1
  set FileDescription=%~2
  Echo ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---
  Echo Description    : %FileDescription%
  Echo Contens of File: %FileToType_DPNE%
  if     exist "%FileToType_DPNE%" type "%FileToType_DPNE%"
  if not exist "%FileToType_DPNE%" Echo Info...........: File.notf.:[%FileToType_DPNE%]
 endlocal
 goto :eof

REM ============================================================================
:Wait
 set waitTime=2
 if "%1" neq "" set waitTime=%1
 CHOICE.exe /C:w /N /T:w,%waitTime% "warte %waitTime%[sec] oder [w] druecken fuer weiter: "
 goto :eof

REM ============================================================================
:Parse_ALL
 REM parst alle File Bezeichner aus
 REM "\" abschneiden
 set Parse_all$temp=%~dp1
 set Parse_all$temp=%Parse_all$temp:~0,-1%
 set %2_DP=%Parse_all$temp%
 set %2_D=%~d1
 REM "\" hinten und vorne abschneiden
 set Parse_all$temp=%~p1
 set Parse_all$temp=%Parse_all$temp:~1,-1%
 set %2_P=%Parse_all$temp%
 set %2_NE=%~nx1
 set %2_N=%~n1
 set %2_E=%~x1
 set %2_DPNE=%1
 set %2_DPN=%~dpn1
 set Parse_all$temp=
goto :eof

REM ============================================================================
:end
