@echo off

 rem ---------------------------------------------------------------------------
 rem JobManager V2 Script fuer den DatenExport mit dem PLMJobManager (c) J.Feuerstein
 rem ---------------------------------------------------------------------------
 rem Dokumentation PLMJobManager Scripts/Param anwendbare Parameter:
 rem set NXDP22_JtTCExport=true = schaltet den Export von JT Files ein
 rem set NXDP21_JtTCUpdate=true	= schaltet JTUpdate ein
 rem set ParasolidExport=true 		= schaltet den Parasolid Export ein
 rem set DXFExport=true       		= schaltet den DXF Export ein
 rem set DWGExport=true       		= schaltet den DWG Export ein
 rem set StepExport=true     	 	= schaltet den Step Export ein
 rem set StepExport=true    	  	= schaltet den Step Export ein

 rem set CheckMate=true         = schaltet CheckMate ein
 rem ---------------------------------------------------------------------------
 rem Aenderungs Info:
 rem                   User   Date/Time         Infotext:
 set MyApplCurVerInfo=J.Fes   30.11.2007        Ersterstellung
 set MyApplCurVerInfo=J.Fes   29.04.2014        Change to JCTools

 rem init Environment
 Echo.
 Echo **************************************************************************
 Echo * executing PLMJobManager script for:                                    *
 Echo *  - exporting NX Data to: Step / JT / Parasolid / DWG / DXF /           *
 Echo *  - creating or updating JT Files for Tc                                *
 Echo *  - %MyApplCurVerInfo%                             *
 Echo **************************************************************************

 set JobMgr_TcUser=%~1
 set JobMgr_TcPw=%~2
 set JobMgr_TcGroup=%~3
 if not defined JobMgr_TcGroup set JobMgr_TcGroup=dba

 if not defined NXDP21_JtTCUpdate set NXDP21_JtTCUpdate=false
 if not defined NXDP22_JtTCExport set NXDP22_JtTCExport=false

 rem -- #Step: JobMgr CmdTools copy local --------------------------------------
 set JobManagerCmdTools_DP=%JobManagerRoot_DP%\03-BinPublic.ClientServer

 set BinL_DP=%CmdCurRoot_DP%\..\BinL
 if not exist "%BinL_DP%" md "%BinL_DP%"
 Call Echo "Upd. JobMgrCmd BinL: [%BinL_DP%]"
 Call Echo "from...............: [%JobManagerCmdTools_DP%]"

 set JobManagerCmdTools_L=%BinL_DP%\JobManagerCmdTools.exe
 set robocopy_opt=/R:5 /W:5
 robocopy %robocopy_opt% /NP /NJS /NJH /NDL /NFL "%JobManagerCmdTools_DP%" "%BinL_DP%" "JobManagerCmdTools.exe">nul 2>nul

 rem new 21.01.2014
 set JFProcessMonitorL_exe=%BinL_DP%\JFProcessMonitor.exe
 robocopy %robocopy_opt% /NP /NJS /NJH /NDL /NFL "%BinPublic_DP%" "%BinL_DP%" "JFProcessMonitor.exe"

 Echo --------------------------------------------------------------------------
 Echo JobName............: %JobName%
 Echo --------------------------------------------------------------------------
 Echo Computer...........: %ComputerName%
 Echo TcUser/Group.......: [%JobMgr_TcUser%/%JobMgr_TcGroup%]
 Echo TcSideId...........: %TcSiteId%
 Echo.
 Echo DataProcessingParm.:
 Echo JT Export..........: %NXDP22_JtTCExport%
 Echo JT TceUpdate.......: %NXDP21_JtTCUpdate%
 REM  Echo StepExport     : %StepExport%
 REM  Echo ParasolidExport: %ParasolidExport%
 REM  Echo DXFExport      : %DXFExport%
 REM  Echo DWGExport      : %DWGExport%
 REM  Echo CheckMate      : %CheckMate%
 Echo --------------------------------------------------------------------------
 Echo.
 if /I "%JobMgr_Debug%" equ "ON" (
   pause
 )
 rem -- JT Update TC Singleparts
 IF /i "%NXDP21_JtTCUpdate%" equ "true" call "NXDP21_JtTCUpdate.cmd"

 if /I "%JobMgr_Debug%" equ "ON" (
   pause
 )
 rem hier ist das Ende des Ablaufes
 rem alle nicht erforderlichen Dateien aus JobDir loeschen
 if /I "%JobMgr_TcNxDebug%" neq "ON" (
       if /I "%JobMgr_Debug%" neq "ON" (
          Echo CleanUp......: %temp%\..
          del /S /Q "%temp%\apiserver.exe*.*","%temp%\*.bak","%temp%\*.tmp","%temp%\*.prt","%temp%\tcserver.*","%temp%\tcserver.*.*">nul 1>nul 2>nul
       )
 )



 rem am Ende
 set temp=%temp_DP_org%
 cd /d "%temp_DP_org%"
 set JobEndDateTime=%Date%/%time:~0,8%
 Echo Job: %JobName% ends %JobEndDateTime%

 Echo --------------------------------------------------------------------------

 if /I "%JobMgr_Debug%" equ "ON" (
   pause
 )
goto :eof

